/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.DocumentMetadata;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"documentType", "storeId", "documentId", "metadata"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentReference {
    public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
    private DocumentTypeEnum documentType;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;
    public static final String JSON_PROPERTY_DOCUMENT_ID = "documentId";
    private String documentId;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private DocumentMetadata metadata;

    public DocumentReference documentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocumentTypeEnum getDocumentType() {
        return this.documentType;
    }

    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
    }

    public DocumentReference storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public DocumentReference documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDocumentId() {
        return this.documentId;
    }

    @JsonProperty(value="documentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DocumentReference metadata(DocumentMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentReference documentReference = (DocumentReference)o;
        return Objects.equals((Object)this.documentType, (Object)documentReference.documentType) && Objects.equals(this.storeId, documentReference.storeId) && Objects.equals(this.documentId, documentReference.documentId) && Objects.equals(this.metadata, documentReference.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentType, this.storeId, this.documentId, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentReference {\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDocumentType() != null) {
            try {
                joiner.add(String.format("%sdocumentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDocumentType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStoreId() != null) {
            try {
                joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDocumentId() != null) {
            try {
                joiner.add(String.format("%sdocumentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDocumentId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMetadata() != null) {
            try {
                joiner.add(String.format("%smetadata%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMetadata()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum DocumentTypeEnum {
        CAMUNDA("camunda"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DocumentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DocumentTypeEnum fromValue(String value) {
            for (DocumentTypeEnum b : DocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

