/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class ThrowErrorCommandImpl
extends CommandWithVariables<ThrowErrorCommandStep1.ThrowErrorCommandStep2>
implements ThrowErrorCommandStep1,
ThrowErrorCommandStep1.ThrowErrorCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.ThrowErrorRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public ThrowErrorCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.ThrowErrorRequest.newBuilder();
        this.builder.setJobKey(key);
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 errorCode(String errorCode) {
        this.builder.setErrorCode(errorCode);
        return this;
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 errorMessage(String errorMsg) {
        this.builder.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.ThrowErrorRequest request = this.builder.build();
        RetriableClientFutureImpl future = new RetriableClientFutureImpl(this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.ThrowErrorResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.ThrowErrorResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.ThrowErrorRequest request, StreamObserver<GatewayOuterClass.ThrowErrorResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).throwError(request, streamObserver);
    }
}

