/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.webapp.graphql.entity.ProcessInstanceDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessService.class);
    @Autowired
    @Qualifier(value="tasklistZeebeClient")
    private ZeebeClient zeebeClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private IdentityAuthorizationService identityAuthorizationService;
    @Autowired
    private UserReader userReader;
    @Autowired
    private ProcessStore processStore;

    public ProcessEntity getProcessByProcessDefinitionKeyAndAccessRestriction(String processDefinitionKey) {
        ProcessEntity processEntity = this.processStore.getProcessByProcessDefinitionKey(processDefinitionKey);
        List<String> processReadAuthorizations = this.identityAuthorizationService.getProcessReadFromAuthorization();
        if (processReadAuthorizations.contains(processEntity.getBpmnProcessId()) || processReadAuthorizations.contains("*")) {
            return processEntity;
        }
        throw new ForbiddenActionException("Resource cannot be accessed");
    }

    public ProcessInstanceDTO startProcessInstance(String processDefinitionKey, String tenantId) {
        return this.startProcessInstance(processDefinitionKey, null, tenantId);
    }

    public ProcessInstanceDTO startProcessInstance(String processDefinitionKey, List<VariableInputDTO> variables, String tenantId) {
        if (!this.identityAuthorizationService.isAllowedToStartProcess(processDefinitionKey)) {
            throw new ForbiddenActionException("User does not have the permission to start this process.");
        }
        boolean isMultiTenancyEnabled = this.tenantService.isMultiTenancyEnabled();
        if (isMultiTenancyEnabled && !this.tenantService.getAuthenticatedTenants().contains(tenantId)) {
            throw new InvalidRequestException("Invalid tenant.");
        }
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(processDefinitionKey).latestVersion();
        if (isMultiTenancyEnabled) {
            createProcessInstanceCommandStep3.tenantId(tenantId);
        }
        if (CollectionUtils.isNotEmpty(variables)) {
            Map<String, Object> variablesMap = variables.stream().collect(Collectors.toMap(VariableInputDTO::getName, this::extractTypedValue));
            createProcessInstanceCommandStep3.variables(variablesMap);
        }
        ProcessInstanceEvent processInstanceEvent = null;
        try {
            processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
            LOGGER.debug("Process instance created for process [{}]", (Object)processDefinitionKey);
        }
        catch (ClientStatusException ex) {
            if (Status.Code.NOT_FOUND.equals((Object)ex.getStatusCode())) {
                throw new NotFoundApiException(String.format("No process definition found with processDefinitionKey: '%s'", processDefinitionKey), ex);
            }
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        catch (ClientException ex) {
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        return new ProcessInstanceDTO().setId(processInstanceEvent.getProcessInstanceKey());
    }

    private Object extractTypedValue(VariableInputDTO variable) {
        if (variable.getValue().equals("null")) {
            return this.objectMapper.nullNode();
        }
        try {
            return this.objectMapper.readValue(variable.getValue(), Object.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

