/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se.store;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.UserEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.UserIndex;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.se.store.UserStore;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ScriptSort;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!sso-auth & !identity-auth"})
@DependsOn(value={"tasklistSchemaStartup"})
@Conditional(value={OpenSearchCondition.class})
public class UserStoreOpenSearch
implements UserStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStoreOpenSearch.class);
    @Autowired
    private UserIndex userIndex;
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient openSearchClient;

    @Override
    public UserEntity getByUserId(String userId) {
        SearchRequest searchRequest = new SearchRequest.Builder().index(this.userIndex.getAlias(), new String[0]).query(q -> q.term(t -> t.field("userId").value(v -> v.stringValue(userId)))).build();
        try {
            SearchResponse response = this.openSearchClient.search(searchRequest, UserEntity.class);
            long totalHits = response.hits().total().value();
            if (totalHits == 1L) {
                return (UserEntity)((Hit)response.hits().hits().stream().findFirst().orElseThrow()).source();
            }
            throw new NotFoundApiException(totalHits > 1L ? String.format("Could not find unique user with userId '%s'.", userId) : String.format("Could not find user with userId '%s'.", userId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the user: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public void create(UserEntity user) {
        try {
            IndexRequest request = IndexRequest.of(builder -> builder.index(this.userIndex.getFullQualifiedName()).id(user.getId()).document((Object)user));
            this.openSearchClient.index(request);
        }
        catch (Exception e) {
            LOGGER.error("Could not create user with user id {}", (Object)user.getUserId(), (Object)e);
        }
    }

    @Override
    public List<UserEntity> getUsersByUserIds(List<String> userIds) {
        ConstantScoreQueryBuilder esQuery = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.idsQuery().addIds((String[])userIds.toArray(String[]::new)));
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(this.userIndex.getAlias(), new String[0]).query(q -> q.constantScore(qs -> qs.filter(qf -> qf.ids(iq -> iq.values(userIds))))).sort(s -> s.script(this.getScriptSort(userIds))).source(s -> s.filter(sf -> sf.includes("userId", new String[]{"displayName"})));
        try {
            return OpenSearchUtil.scroll((SearchRequest.Builder)searchRequest, UserEntity.class, (OpenSearchClient)this.openSearchClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining users: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private ScriptSort getScriptSort(List<String> userIds) {
        String scriptCode = String.format("def userIdsCount = params.userIds.size();def userId = doc['%s'].value;def foundIdx = params.userIds.indexOf(userId);return foundIdx > -1 ? foundIdx: userIdsCount + 1;", "userId");
        return new ScriptSort.Builder().type(ScriptSortType.Number).script(s -> s.inline(is -> (ObjectBuilder)is.lang("painless").source(scriptCode).params("userIds", JsonData.of((Object)userIds)))).order(SortOrder.Asc).build();
    }
}

