/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.tenant;

import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.tenant.TenantCheckApplier;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticSearchCondition.class})
@Component
public class ElasticsearchTenantCheckApplier
implements TenantCheckApplier<SearchRequest> {
    @Autowired
    private TenantService tenantService;

    public void apply(SearchRequest searchRequest) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        List<String> searchByTenantIds = tenants.getTenantIds();
        ElasticsearchTenantCheckApplier.applyTenantCheckOnQuery(searchRequest, tenantCheckQueryType, searchByTenantIds);
    }

    public void apply(SearchRequest searchRequest, Collection<String> tenantIds) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        Set<String> authorizedTenantIds = Set.copyOf(tenants.getTenantIds());
        Set<String> searchByTenantIds = tenantIds.stream().filter(authorizedTenantIds::contains).collect(Collectors.toSet());
        ElasticsearchTenantCheckApplier.applyTenantCheckOnQuery(searchRequest, tenantCheckQueryType, searchByTenantIds);
    }

    private static void applyTenantCheckOnQuery(SearchRequest searchRequest, TenantService.TenantAccessType tenantCheckQueryType, Collection<String> searchByTenantIds) {
        QueryBuilder actualQuery = searchRequest.source().query();
        switch (tenantCheckQueryType) {
            case TENANT_ACCESS_ASSIGNED: {
                BoolQueryBuilder finalQuery;
                if (CollectionUtils.isEmpty(searchByTenantIds)) {
                    finalQuery = ElasticsearchUtil.createMatchNoneQuery();
                } else {
                    TermsQueryBuilder tenantTermsQuery = QueryBuilders.termsQuery((String)"tenantId", searchByTenantIds);
                    finalQuery = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{tenantTermsQuery, actualQuery});
                }
                searchRequest.source().query((QueryBuilder)finalQuery);
                break;
            }
            case TENANT_ACCESS_NONE: {
                searchRequest.source().query((QueryBuilder)ElasticsearchUtil.createMatchNoneQuery());
                break;
            }
            case TENANT_ACCESS_ALL: {
                searchRequest.source().query(actualQuery);
                break;
            }
            default: {
                String message = String.format("Unexpected tenant check query type %s", new Object[]{tenantCheckQueryType});
                throw new TasklistRuntimeException(message);
            }
        }
    }
}

