/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import io.camunda.tasklist.management.ILMPolicyUpdate;
import io.camunda.tasklist.property.TasklistProperties;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"tasklistSchemaStartup"})
public class ILMService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ILMService.class);
    @Autowired
    private ILMPolicyUpdate ilmPolicyUpdate;
    @Autowired
    private TasklistProperties tasklistProperties;

    @PostConstruct
    public void init() throws IOException {
        if (this.tasklistProperties.isArchiverEnabled()) {
            if (this.tasklistProperties.getArchiver().isIlmEnabled()) {
                this.applyIlmPolicyToAllIndices();
            } else {
                this.removeIlmPolicyFromAllIndices();
            }
        } else {
            LOGGER.info("Archiver is not enabled, skipping ILM policy update");
        }
    }

    private void applyIlmPolicyToAllIndices() throws IOException {
        this.ilmPolicyUpdate.applyIlmPolicyToAllIndices();
    }

    private void removeIlmPolicyFromAllIndices() throws IOException {
        this.ilmPolicyUpdate.removeIlmPolicyFromAllIndices();
    }
}

