/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@ConditionalOnExpression(value="${camunda.tasklist.persistent.sessions.enabled:false} or ${camunda.tasklist.persistentSessionsEnabled:false}")
public class SessionRepositoryConfigurator {
    @Bean(value={"sessionThreadPoolScheduler"})
    public ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler executor = new ThreadPoolTaskScheduler();
        executor.setPoolSize(5);
        executor.setThreadNamePrefix("tasklist_session_");
        executor.initialize();
        return executor;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("TASKLIST-SESSION");
        serializer.setUseBase64Encoding(false);
        return serializer;
    }
}

