/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfRequireMatcher
implements RequestMatcher {
    private static final Pattern ALLOWED_METHODS = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private static final Pattern ALLOWED_PATHS = Pattern.compile("/api/login|/api/logout");

    public boolean matches(HttpServletRequest request) {
        boolean isAuthorizationHeaderPresent;
        boolean isUserAuthenticated;
        if (ALLOWED_METHODS.matcher(request.getMethod()).matches()) {
            return false;
        }
        if (ALLOWED_PATHS.matcher(request.getServletPath()).matches()) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = isUserAuthenticated = authentication != null && authentication.isAuthenticated();
        if (!isUserAuthenticated) {
            return false;
        }
        String referer = request.getHeader("Referer");
        if (referer != null && referer.matches(".*/swagger-ui.*")) {
            return false;
        }
        String authorizationHeader = request.getHeader("Authorization");
        boolean bl2 = isAuthorizationHeaderPresent = authorizationHeader != null && authorizationHeader.startsWith("Bearer ");
        return !isAuthorizationHeaderPresent;
    }
}

