/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es;

import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.security.UserReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskValidator {
    @Autowired
    private UserReader userReader;

    public void validateCanPersistDraftTaskVariables(TaskEntity task) {
        this.validateTaskStateAndAssignment(task);
    }

    public void validateCanComplete(TaskEntity taskBefore) {
        this.validateTaskStateAndAssignment(taskBefore);
    }

    private void validateTaskStateAndAssignment(TaskEntity task) {
        TaskValidator.validateTaskIsActive(task);
        UserDTO currentUser = this.getCurrentUser();
        if (currentUser.isApiUser()) {
            return;
        }
        TaskValidator.validateTaskIsAssigned(task);
        if (!task.getAssignee().equals(currentUser.getUserId())) {
            throw new InvalidRequestException("Task is not assigned to " + currentUser.getUserId());
        }
    }

    public void validateCanAssign(TaskEntity taskBefore, boolean allowOverrideAssignment) {
        TaskValidator.validateTaskIsActive(taskBefore);
        if (this.getCurrentUser().isApiUser() && allowOverrideAssignment) {
            return;
        }
        if (taskBefore.getAssignee() != null) {
            throw new InvalidRequestException("Task is already assigned");
        }
    }

    public void validateCanUnassign(TaskEntity taskBefore) {
        TaskValidator.validateTaskIsActive(taskBefore);
        TaskValidator.validateTaskIsAssigned(taskBefore);
    }

    private static void validateTaskIsActive(TaskEntity taskBefore) {
        if (!taskBefore.getState().equals((Object)TaskState.CREATED)) {
            throw new InvalidRequestException("Task is not active");
        }
    }

    private static void validateTaskIsAssigned(TaskEntity taskBefore) {
        if (taskBefore.getAssignee() == null) {
            throw new InvalidRequestException("Task is not assigned");
        }
    }

    private UserDTO getCurrentUser() {
        return this.userReader.getCurrentUser();
    }
}

