/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.auth.TokenResponse;

public interface TokenResponseMapper {
    public TokenResponse readToken(String var1);

    public static class JacksonTokenResponseMapper
    implements TokenResponseMapper {
        private final ObjectMapper objectMapper;

        public JacksonTokenResponseMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public TokenResponse readToken(String token) {
            try {
                return (TokenResponse)this.objectMapper.readValue(token, TokenResponse.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error while reading token " + token, e);
            }
        }
    }
}

