/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.BatchOperationItemState;
import io.camunda.client.api.search.enums.BatchOperationType;
import io.camunda.client.api.search.response.BatchOperationItems;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.BatchOperationItemResponse;
import io.camunda.client.protocol.rest.BatchOperationItemSearchQueryResult;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public class BatchOperationItemsImpl
implements BatchOperationItems {
    private final List<BatchOperationItems.BatchOperationItem> items;

    public BatchOperationItemsImpl(BatchOperationItemSearchQueryResult queryResult) {
        this.items = queryResult.getItems().stream().map(BatchOperationItemImpl::new).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    @Override
    public List<BatchOperationItems.BatchOperationItem> items() {
        return this.items;
    }

    public static class BatchOperationItemImpl
    implements BatchOperationItems.BatchOperationItem {
        private final String batchOperationKey;
        private final BatchOperationType operationType;
        private final Long itemKey;
        private final Long processInstanceKey;
        private final BatchOperationItemState status;
        private final OffsetDateTime processedDate;
        private final String errorMessage;

        public BatchOperationItemImpl(BatchOperationItemResponse item) {
            this.batchOperationKey = item.getBatchOperationKey();
            this.operationType = EnumUtil.convert(item.getOperationType(), BatchOperationType.class);
            this.itemKey = ParseUtil.parseLongOrNull(item.getItemKey());
            this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
            this.status = EnumUtil.convert(item.getState(), BatchOperationItemState.class);
            this.processedDate = ParseUtil.parseOffsetDateTimeOrNull(item.getProcessedDate());
            this.errorMessage = item.getErrorMessage();
        }

        @Override
        public String getBatchOperationKey() {
            return this.batchOperationKey;
        }

        @Override
        public BatchOperationType getOperationType() {
            return this.operationType;
        }

        @Override
        public Long getItemKey() {
            return this.itemKey;
        }

        @Override
        public Long getProcessInstanceKey() {
            return this.processInstanceKey;
        }

        @Override
        public OffsetDateTime getProcessedDate() {
            return this.processedDate;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public BatchOperationItemState getStatus() {
            return this.status;
        }
    }
}

