/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.MessageSubscriptionSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.MessageSubscriptionSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.MessageSubscriptionFilter;
import io.camunda.client.protocol.rest.MessageSubscriptionSearchQuery;
import io.camunda.client.protocol.rest.MessageSubscriptionSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class MessageSubscriptionSearchRequestImpl
extends TypedSearchRequestPropertyProvider<MessageSubscriptionSearchQuery>
implements MessageSubscriptionSearchRequest {
    private final MessageSubscriptionSearchQuery request = new MessageSubscriptionSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public MessageSubscriptionSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<MessageSubscription> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<MessageSubscription>> send() {
        HttpCamundaFuture<SearchResponse<MessageSubscription>> result = new HttpCamundaFuture<SearchResponse<MessageSubscription>>();
        this.httpClient.post("message-subscriptions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), MessageSubscriptionSearchQueryResult.class, SearchResponseMapper::toMessageSubscriptionSearchResponse, result);
        return result;
    }

    @Override
    public MessageSubscriptionSearchRequest filter(io.camunda.client.api.search.filter.MessageSubscriptionFilter value) {
        this.request.setFilter((MessageSubscriptionFilter)MessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MessageSubscriptionSearchRequest filter(Consumer<io.camunda.client.api.search.filter.MessageSubscriptionFilter> fn) {
        return this.filter(SearchRequestBuilders.messageSubscriptionFilter(fn));
    }

    @Override
    public MessageSubscriptionSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)MessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MessageSubscriptionSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public MessageSubscriptionSearchRequest sort(MessageSubscriptionSort value) {
        this.request.setSort(SearchRequestSortMapper.toMessageSubscriptionSearchQuerySortRequest((List)MessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public MessageSubscriptionSearchRequest sort(Consumer<MessageSubscriptionSort> fn) {
        return this.sort(SearchRequestBuilders.messageSubscriptionSort(fn));
    }

    @Override
    protected MessageSubscriptionSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

