/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.TenantGroupFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.GroupsByTenantSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.TenantGroup;
import io.camunda.client.api.search.sort.TenantGroupSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.TenantGroupSearchQueryRequest;
import io.camunda.client.protocol.rest.TenantGroupSearchResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class GroupsByTenantSearchRequestImpl
extends TypedSearchRequestPropertyProvider<TenantGroupSearchQueryRequest>
implements GroupsByTenantSearchRequest {
    private final TenantGroupSearchQueryRequest request;
    private final String tenantId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public GroupsByTenantSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String tenantId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new TenantGroupSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<TenantGroup> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<TenantGroup>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        HttpCamundaFuture<SearchResponse<TenantGroup>> result = new HttpCamundaFuture<SearchResponse<TenantGroup>>();
        this.httpClient.post(String.format("/tenants/%s/groups/search", this.tenantId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantGroupSearchResult.class, SearchResponseMapper::toTenantGroupsResponse, result);
        return result;
    }

    @Override
    public GroupsByTenantSearchRequest filter(TenantGroupFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public GroupsByTenantSearchRequest filter(Consumer<TenantGroupFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public GroupsByTenantSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)GroupsByTenantSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsByTenantSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public GroupsByTenantSearchRequest sort(TenantGroupSort value) {
        this.request.setSort(SearchRequestSortMapper.toTenantGroupSearchQuerySortRequest((List)GroupsByTenantSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public GroupsByTenantSearchRequest sort(Consumer<TenantGroupSort> fn) {
        return this.sort(SearchRequestBuilders.tenantGroupSort(fn));
    }

    @Override
    protected TenantGroupSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

