/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.request.ElementInstanceSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ElementInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ElementInstanceSearchQuery;
import io.camunda.client.protocol.rest.ElementInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ElementInstanceSearchRequestImpl
extends TypedSearchRequestPropertyProvider<ElementInstanceSearchQuery>
implements ElementInstanceSearchRequest {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final ElementInstanceSearchQuery request = new ElementInstanceSearchQuery();
    private final RequestConfig.Builder httpRequestConfig;

    public ElementInstanceSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<ElementInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<ElementInstance>> send() {
        HttpCamundaFuture<SearchResponse<ElementInstance>> result = new HttpCamundaFuture<SearchResponse<ElementInstance>>();
        this.httpClient.post("/element-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ElementInstanceSearchQueryResult.class, SearchResponseMapper::toElementInstanceSearchResponse, result);
        return result;
    }

    @Override
    public ElementInstanceSearchRequest filter(ElementInstanceFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.ElementInstanceFilter)ElementInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ElementInstanceSearchRequest filter(Consumer<ElementInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.elementInstanceFilter(fn));
    }

    @Override
    public ElementInstanceSearchRequest sort(ElementInstanceSort value) {
        this.request.setSort(SearchRequestSortMapper.toElementInstanceSearchQuerySortRequest((List)ElementInstanceSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ElementInstanceSearchRequest sort(Consumer<ElementInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.elementInstanceSort(fn));
    }

    @Override
    public ElementInstanceSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ElementInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ElementInstanceSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ElementInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

