/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.BatchOperationFilter;
import io.camunda.client.api.search.request.BatchOperationSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.BatchOperation;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.BatchOperationSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.BatchOperationSearchQuery;
import io.camunda.client.protocol.rest.BatchOperationSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class BatchOperationSearchRequestImpl
extends TypedSearchRequestPropertyProvider<BatchOperationSearchQuery>
implements BatchOperationSearchRequest {
    private final BatchOperationSearchQuery request = new BatchOperationSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public BatchOperationSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public BatchOperationSearchRequest filter(BatchOperationFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.BatchOperationFilter)BatchOperationSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public BatchOperationSearchRequest filter(Consumer<BatchOperationFilter> fn) {
        return this.filter(SearchRequestBuilders.batchOperationFilter(fn));
    }

    @Override
    public BatchOperationSearchRequest sort(BatchOperationSort value) {
        this.request.setSort(SearchRequestSortMapper.toBatchOperationSearchQuerySortRequest((List)BatchOperationSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public BatchOperationSearchRequest sort(Consumer<BatchOperationSort> fn) {
        return this.sort(SearchRequestBuilders.batchOperationSort(fn));
    }

    @Override
    public BatchOperationSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)BatchOperationSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public BatchOperationSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected BatchOperationSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchRequestStep<BatchOperation> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<BatchOperation>> send() {
        HttpCamundaFuture<SearchResponse<BatchOperation>> result = new HttpCamundaFuture<SearchResponse<BatchOperation>>();
        this.httpClient.post("/batch-operations/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), BatchOperationSearchQueryResult.class, SearchResponseMapper::toBatchOperationsResponse, result);
        return result;
    }
}

