/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.DeleteUserCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteUserResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DeleteUserResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteUserCommandImpl
implements DeleteUserCommandStep1 {
    private final String username;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DeleteUserCommandImpl(HttpClient httpClient, String username) {
        this.username = username;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<DeleteUserResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteUserResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("username", this.username);
        HttpCamundaFuture<DeleteUserResponse> result = new HttpCamundaFuture<DeleteUserResponse>();
        this.httpClient.delete("/users/" + this.username, this.httpRequestConfig.build(), DeleteUserResponseImpl::new, result);
        return result;
    }
}

