/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.DeleteTenantCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteTenantResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DeleteTenantResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class DeleteTenantCommandImpl
implements DeleteTenantCommandStep1 {
    private String tenantId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DeleteTenantCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DeleteTenantCommandStep1 tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public FinalCommandStep<DeleteTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteTenantResponse> send() {
        HttpCamundaFuture<DeleteTenantResponse> result = new HttpCamundaFuture<DeleteTenantResponse>();
        this.httpClient.delete("/tenants/" + this.tenantId, this.httpRequestConfig.build(), DeleteTenantResponseImpl::new, result);
        return result;
    }
}

