/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateMappingRuleCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateMappingRuleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateMappingRuleResponseImpl;
import io.camunda.client.protocol.rest.MappingRuleCreateRequest;
import io.camunda.client.protocol.rest.MappingRuleCreateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateMappingRuleCommandImpl
implements CreateMappingRuleCommandStep1 {
    private final MappingRuleCreateRequest mappingRuleRequest;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateMappingRuleCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.mappingRuleRequest = new MappingRuleCreateRequest();
    }

    @Override
    public CreateMappingRuleCommandStep1 claimName(String claimName) {
        this.mappingRuleRequest.claimName(claimName);
        return this;
    }

    @Override
    public CreateMappingRuleCommandStep1 claimValue(String claimValue) {
        this.mappingRuleRequest.claimValue(claimValue);
        return this;
    }

    @Override
    public CreateMappingRuleCommandStep1 name(String name) {
        this.mappingRuleRequest.name(name);
        return this;
    }

    @Override
    public CreateMappingRuleCommandStep1 mappingRuleId(String mappingRuleId) {
        this.mappingRuleRequest.mappingRuleId(mappingRuleId);
        return this;
    }

    @Override
    public FinalCommandStep<CreateMappingRuleResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateMappingRuleResponse> send() {
        ArgumentUtil.ensureNotNull("claimName", this.mappingRuleRequest.getClaimName());
        ArgumentUtil.ensureNotNull("claimValue", this.mappingRuleRequest.getClaimValue());
        ArgumentUtil.ensureNotNull("name", this.mappingRuleRequest.getName());
        ArgumentUtil.ensureNotNull("mappingRuleId", this.mappingRuleRequest.getMappingRuleId());
        HttpCamundaFuture<CreateMappingRuleResponse> result = new HttpCamundaFuture<CreateMappingRuleResponse>();
        CreateMappingRuleResponseImpl response = new CreateMappingRuleResponseImpl();
        this.httpClient.post("/mapping-rules", this.jsonMapper.toJson(this.mappingRuleRequest), this.httpRequestConfig.build(), MappingRuleCreateResult.class, response::setResponse, result);
        return result;
    }
}

