/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.http;

import io.bytom.exception.BytomException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Date;
import org.apache.log4j.Logger;

public class Response {
    private static final boolean DEBUG = true;
    static Logger log = Logger.getLogger((String)Response.class.getName());
    private int statusCode;
    private String responseAsString = null;
    private InputStream is;
    private HttpURLConnection con;
    private boolean streamConsumed = false;

    public Response() {
    }

    public Response(HttpURLConnection con) throws IOException {
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
    }

    public Response(String content) {
        this.responseAsString = content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        if (this.con != null) {
            return this.con.getHeaderField(name);
        }
        return null;
    }

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws BytomException {
        if (null == this.responseAsString) {
            try {
                String line;
                InputStream stream = this.asStream();
                if (null == stream) {
                    return null;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuffer buf = new StringBuffer();
                while (null != (line = br.readLine())) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                this.log(this.responseAsString);
                stream.close();
                this.con.disconnect();
                this.streamConsumed = true;
            }
            catch (NullPointerException npe) {
                throw new BytomException(npe.getMessage(), npe);
            }
            catch (IOException ioe) {
                throw new BytomException(ioe.getMessage(), ioe);
            }
        }
        return this.responseAsString;
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public String toString() {
        if (null != this.responseAsString) {
            return this.responseAsString;
        }
        return "Response{statusCode=" + this.statusCode + ", responseString='" + this.responseAsString + '\'' + ", is=" + this.is + ", con=" + this.con + '}';
    }

    private void log(String message) {
        log.debug((Object)("[" + new Date() + "]" + message));
    }

    public String getResponseAsString() {
        return this.responseAsString;
    }

    public void setResponseAsString(String responseAsString) {
        this.responseAsString = responseAsString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}

