/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.exception.BytomException;
import io.bytom.http.BytomResponse;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;

public class Token {
    public String id;
    public String token;
    public String type;
    @SerializedName(value="created_at", alternate={"create"})
    public String create;

    public static boolean check(Client client, String id, String secret) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", id);
        req.put("secret", secret);
        return client.request("check-access-token", req);
    }

    public static boolean delete(Client client, String id) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", id);
        return client.request("delete-access-token", req);
    }

    public static Items list(Client client) throws BytomException {
        Items items = new Items();
        items.setClient(client);
        return items.query();
    }

    public static class Items
    extends BytomResponse<Token> {
        public Items query() throws BytomException {
            Items items = (Items)this.client.requestList("list-access-tokens", null, (Type)((Object)Items.class));
            return items;
        }
    }

    public static class Builder {
        public String id;
        public String type;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Token create(Client client) throws BytomException {
            return (Token)client.request("create-access-token", this, (Type)((Object)Token.class));
        }
    }
}

