/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import io.bytom.exception.BytomException;
import io.bytom.http.BytomResponse;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;

public class Key {
    public String alias;
    public String xpub;
    public String file;

    public static Key create(Client client, String alias, String password) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("alias", alias);
        req.put("password", password);
        return (Key)client.request("create-key", req, (Type)((Object)Key.class));
    }

    public static boolean delete(Client client, String xpub, String password) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("xpub", xpub);
        req.put("password", password);
        return client.request("delete-key", req);
    }

    public static boolean resetPassword(Client client, String xpub, String old_password, String new_password) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("xpub", xpub);
        req.put("old_password", old_password);
        req.put("new_password", new_password);
        return client.request("reset-key-password", req);
    }

    public static class QueryBuilder {
        public Items list(Client client) throws BytomException {
            Items items = new Items();
            items.setClient(client);
            return items.query();
        }
    }

    public static class Items
    extends BytomResponse<Key> {
        public Items query() throws BytomException {
            Items items = (Items)this.client.requestList("list-keys", null, (Type)((Object)Items.class));
            return items;
        }
    }
}

