/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SortByFunction
extends BaseFunction {
    public SortByFunction() {
        super(ArgumentConstraints.arrayOf(ArgumentConstraints.typeOf(JmesPathType.OBJECT)), ArgumentConstraints.expression());
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        List<T> elementsList = runtime.toList(arguments.get(0).value());
        Expression<T> expression = arguments.get(1).expression();
        Iterator<T> elements = elementsList.iterator();
        if (elements.hasNext()) {
            ArrayList<Pair<T>> pairs = new ArrayList<Pair<T>>(elementsList.size());
            T element = elements.next();
            T transformedElement = expression.search(element);
            boolean expectNumbers = this.expectNumbers(runtime, transformedElement);
            pairs.add(new Pair<T>(transformedElement, element));
            while (elements.hasNext()) {
                element = elements.next();
                transformedElement = expression.search(element);
                this.checkType(runtime, transformedElement, expectNumbers);
                pairs.add(new Pair<T>(transformedElement, element));
            }
            return runtime.createArray(this.sortAndFlatten(runtime, pairs));
        }
        return runtime.createArray(new ArrayList());
    }

    private <T> boolean expectNumbers(Adapter<T> runtime, T transformedElement) {
        JmesPathType elementType = runtime.typeOf(transformedElement);
        if (elementType == JmesPathType.STRING) {
            return false;
        }
        if (elementType != JmesPathType.NUMBER) {
            throw new ArgumentTypeException(this.name(), "number or string", elementType.toString());
        }
        return true;
    }

    private <T> void checkType(Adapter<T> runtime, T transformedElement, boolean expectNumbers) {
        JmesPathType elementType = runtime.typeOf(transformedElement);
        if (expectNumbers && elementType != JmesPathType.NUMBER) {
            throw new ArgumentTypeException(this.name(), "number", elementType.toString());
        }
        if (!expectNumbers && elementType != JmesPathType.STRING) {
            throw new ArgumentTypeException(this.name(), "string", elementType.toString());
        }
    }

    private <T> List<T> sortAndFlatten(final Adapter<T> runtime, List<Pair<T>> pairs) {
        Collections.sort(pairs, new Comparator<Pair<T>>(){

            @Override
            public int compare(Pair<T> a, Pair<T> b) {
                return runtime.compare(a.transformedElement, b.transformedElement);
            }
        });
        ArrayList sorted = new ArrayList(pairs.size());
        for (Pair<T> pair : pairs) {
            sorted.add(pair.element);
        }
        return sorted;
    }

    private static class Pair<U> {
        public final U transformedElement;
        public final U element;

        public Pair(U transformedElement, U element) {
            this.transformedElement = transformedElement;
            this.element = element;
        }
    }
}

