/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.function.FunctionCallException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ArgumentConstraints {
    private static final String EXPRESSION_TYPE = "expression";

    public static ArgumentConstraint listOf(ArgumentConstraint ... constraints) {
        return new HeterogenousListOf(constraints);
    }

    public static ArgumentConstraint listOf(int min, int max, ArgumentConstraint constraint) {
        return new HomogenousListOf(min, max, constraint);
    }

    public static ArgumentConstraint anyValue() {
        return new AnyValue();
    }

    public static ArgumentConstraint typeOf(JmesPathType type) {
        return new TypeOf(type);
    }

    public static ArgumentConstraint typeOf(JmesPathType ... types) {
        return new TypeOfEither(types);
    }

    public static ArgumentConstraint arrayOf(ArgumentConstraint constraint) {
        return new ArrayOf(constraint);
    }

    public static ArgumentConstraint expression() {
        return new Expression();
    }

    private ArgumentConstraints() {
    }

    private static class ArrayOf
    implements ArgumentConstraint {
        private ArgumentConstraint subConstraint;

        public ArrayOf(ArgumentConstraint subConstraint) {
            this.subConstraint = subConstraint;
        }

        @Override
        public <T> void check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments) {
            T value;
            if (arguments.hasNext()) {
                FunctionArgument<T> argument = arguments.next();
                if (argument.isExpression()) {
                    throw new InternalArgumentTypeException(this.expectedType(), ArgumentConstraints.EXPRESSION_TYPE);
                }
                value = argument.value();
                JmesPathType type = runtime.typeOf(value);
                if (type != JmesPathType.ARRAY) {
                    throw new InternalArgumentTypeException(this.expectedType(), type.toString());
                }
            } else {
                throw new InternalArityException();
            }
            this.checkElements(runtime, value);
        }

        private <T> void checkElements(Adapter<T> runtime, T value) {
            List<T> elements = runtime.toList(value);
            if (!elements.isEmpty()) {
                ArrayList<FunctionArgument<T>> wrappedElements = new ArrayList<FunctionArgument<T>>(elements.size());
                LinkedHashSet<JmesPathType> types = new LinkedHashSet<JmesPathType>();
                for (T element : elements) {
                    wrappedElements.add(FunctionArgument.of(element));
                    types.add(runtime.typeOf(element));
                }
                if (types.size() > 1) {
                    this.handleMixedError(types);
                }
                Iterator wrappedElementsIterator = wrappedElements.iterator();
                while (wrappedElementsIterator.hasNext()) {
                    try {
                        this.subConstraint.check(runtime, wrappedElementsIterator);
                    }
                    catch (InternalArgumentTypeException iate) {
                        throw new InternalArgumentTypeException(this.expectedType(), String.format("array containing %s", iate.actualType()), iate);
                    }
                }
            }
        }

        private void handleMixedError(Set<JmesPathType> types) {
            StringBuilder actualTypes = new StringBuilder("array containing ");
            Object[] typesArray = types.toArray();
            for (int i = 0; i < typesArray.length; ++i) {
                actualTypes.append(typesArray[i].toString());
                if (i < typesArray.length - 2) {
                    actualTypes.append(", ");
                    continue;
                }
                if (i >= typesArray.length - 1) continue;
                actualTypes.append(" and ");
            }
            throw new InternalArgumentTypeException(this.expectedType(), actualTypes.toString());
        }

        @Override
        public int minArity() {
            return 1;
        }

        @Override
        public int maxArity() {
            return 1;
        }

        @Override
        public String expectedType() {
            return String.format("array of %s", this.subConstraint.expectedType());
        }
    }

    private static class Expression
    extends TypeCheck {
        private Expression() {
        }

        @Override
        protected <T> void checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (!argument.isExpression()) {
                throw new InternalArgumentTypeException(ArgumentConstraints.EXPRESSION_TYPE, runtime.typeOf(argument.value()).toString());
            }
        }

        @Override
        public int minArity() {
            return 1;
        }

        @Override
        public int maxArity() {
            return 1;
        }

        @Override
        public String expectedType() {
            return ArgumentConstraints.EXPRESSION_TYPE;
        }
    }

    private static class TypeOfEither
    extends TypeCheck {
        private final JmesPathType[] expectedTypes;
        private final String expectedTypeString;

        public TypeOfEither(JmesPathType[] expectedTypes) {
            this.expectedTypes = expectedTypes;
            this.expectedTypeString = this.createExpectedTypeString(expectedTypes);
        }

        private String createExpectedTypeString(JmesPathType[] expectedTypes) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < expectedTypes.length; ++i) {
                buffer.append((Object)expectedTypes[i]);
                if (i < expectedTypes.length - 2) {
                    buffer.append(", ");
                    continue;
                }
                if (i >= expectedTypes.length - 1) continue;
                buffer.append(" or ");
            }
            return buffer.toString();
        }

        @Override
        protected <T> void checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                throw new InternalArgumentTypeException(this.expectedTypeString, ArgumentConstraints.EXPRESSION_TYPE);
            }
            JmesPathType actualType = runtime.typeOf(argument.value());
            for (int i = 0; i < this.expectedTypes.length; ++i) {
                if (this.expectedTypes[i] != actualType) continue;
                return;
            }
            throw new InternalArgumentTypeException(this.expectedTypeString, actualType.toString());
        }

        @Override
        public String expectedType() {
            return this.expectedTypeString;
        }
    }

    private static class TypeOf
    extends TypeCheck {
        private final JmesPathType expectedType;

        public TypeOf(JmesPathType expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        protected <T> void checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                throw new InternalArgumentTypeException(this.expectedType.toString(), ArgumentConstraints.EXPRESSION_TYPE);
            }
            JmesPathType actualType = runtime.typeOf(argument.value());
            if (actualType != this.expectedType) {
                throw new InternalArgumentTypeException(this.expectedType.toString(), actualType.toString());
            }
        }

        @Override
        public String expectedType() {
            return this.expectedType.toString();
        }
    }

    private static class AnyValue
    extends TypeCheck {
        private AnyValue() {
        }

        @Override
        protected <T> void checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                throw new InternalArgumentTypeException("any value", ArgumentConstraints.EXPRESSION_TYPE);
            }
        }

        @Override
        public String expectedType() {
            return "any value";
        }
    }

    private static abstract class TypeCheck
    implements ArgumentConstraint {
        private TypeCheck() {
        }

        @Override
        public <T> void check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments) {
            if (!arguments.hasNext()) {
                throw new InternalArityException();
            }
            this.checkType(runtime, arguments.next());
        }

        protected abstract <T> void checkType(Adapter<T> var1, FunctionArgument<T> var2);

        @Override
        public int minArity() {
            return 1;
        }

        @Override
        public int maxArity() {
            return 1;
        }
    }

    private static class HeterogenousListOf
    implements ArgumentConstraint {
        private final ArgumentConstraint[] subConstraints;
        private final int minArity;
        private final int maxArity;

        public HeterogenousListOf(ArgumentConstraint[] subConstraints) {
            this.subConstraints = subConstraints;
            int min = 0;
            int max = 0;
            for (ArgumentConstraint constraint : subConstraints) {
                min += constraint.minArity();
                max += constraint.maxArity();
            }
            this.minArity = min;
            this.maxArity = max;
        }

        @Override
        public <T> void check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments) {
            for (int i = 0; i < this.subConstraints.length; ++i) {
                if (!arguments.hasNext()) {
                    throw new InternalArityException();
                }
                this.subConstraints[i].check(runtime, arguments);
            }
        }

        @Override
        public int minArity() {
            return this.minArity;
        }

        @Override
        public int maxArity() {
            return this.maxArity;
        }

        @Override
        public String expectedType() {
            throw new IllegalStateException("A heterogenous list constraint does not have an expected type");
        }
    }

    private static class HomogenousListOf
    implements ArgumentConstraint {
        private final ArgumentConstraint subConstraint;
        private final int minArity;
        private final int maxArity;

        public HomogenousListOf(int minArity, int maxArity, ArgumentConstraint subConstraint) {
            this.subConstraint = subConstraint;
            this.minArity = minArity;
            this.maxArity = maxArity;
        }

        @Override
        public <T> void check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments) {
            int i;
            for (i = 0; i < this.minArity; ++i) {
                if (!arguments.hasNext()) {
                    throw new InternalArityException();
                }
                this.subConstraint.check(runtime, arguments);
            }
            while (i < this.maxArity && arguments.hasNext()) {
                this.subConstraint.check(runtime, arguments);
                ++i;
            }
        }

        @Override
        public int minArity() {
            return this.minArity;
        }

        @Override
        public int maxArity() {
            return this.maxArity;
        }

        @Override
        public String expectedType() {
            return this.subConstraint.expectedType();
        }
    }

    static class InternalArityException
    extends FunctionCallException {
        public InternalArityException() {
            super("");
        }
    }

    static class InternalArgumentTypeException
    extends FunctionCallException {
        private final String expectedType;
        private final String actualType;

        public InternalArgumentTypeException(String expectedType, String actualType) {
            this(expectedType, actualType, null);
        }

        public InternalArgumentTypeException(String expectedType, String actualType, Throwable cause) {
            super("", cause);
            this.expectedType = expectedType;
            this.actualType = actualType;
        }

        public String expectedType() {
            return this.expectedType;
        }

        public String actualType() {
            return this.actualType;
        }
    }
}

