/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.node.Node;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class OperatorNode<T>
extends Node<T> {
    private final List<Expression<T>> operands;

    @SafeVarargs
    public OperatorNode(Adapter<T> runtime, Expression<T> ... operands) {
        super(runtime);
        this.operands = Arrays.asList(operands);
    }

    protected Expression<T> operand(int index) {
        return this.operands.get(index);
    }

    @Override
    protected String internalToString() {
        StringBuilder operandsString = new StringBuilder();
        Iterator<Expression<T>> operandIterator = this.operands.iterator();
        while (operandIterator.hasNext()) {
            Expression<T> operand = operandIterator.next();
            operandsString.append(operand);
            if (!operandIterator.hasNext()) continue;
            operandsString.append(", ");
        }
        return operandsString.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        OperatorNode other = (OperatorNode)o;
        return this.operands.equals(other.operands);
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        for (Expression<T> node : this.operands) {
            h = h * 31 + node.hashCode();
        }
        return h;
    }
}

