/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.Iterator;
import java.util.List;

public abstract class CompareByFunction
extends BaseFunction {
    public CompareByFunction() {
        super(ArgumentConstraints.arrayOf(ArgumentConstraints.typeOf(JmesPathType.OBJECT)), ArgumentConstraints.expression());
    }

    protected abstract boolean sortsBefore(int var1);

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        Iterator<T> elements = runtime.toList(arguments.get(0).value()).iterator();
        Expression<T> expression = arguments.get(1).expression();
        if (elements.hasNext()) {
            T result = elements.next();
            T resultValue = expression.search(result);
            boolean expectNumbers = this.expectNumbers(runtime, resultValue);
            while (elements.hasNext()) {
                T candidate = elements.next();
                T candidateValue = expression.search(candidate);
                this.checkType(runtime, candidateValue, expectNumbers);
                if (!this.sortsBefore(runtime.compare(candidateValue, resultValue))) continue;
                result = candidate;
                resultValue = candidateValue;
            }
            return result;
        }
        return runtime.createNull();
    }

    private <T> boolean expectNumbers(Adapter<T> runtime, T resultValue) {
        if (runtime.typeOf(resultValue) == JmesPathType.STRING) {
            return false;
        }
        if (runtime.typeOf(resultValue) != JmesPathType.NUMBER) {
            throw new ArgumentTypeException(this.name(), "number or string", runtime.typeOf(resultValue).toString());
        }
        return true;
    }

    private <T> void checkType(Adapter<T> runtime, T candidateValue, boolean expectNumbers) {
        JmesPathType candidateType = runtime.typeOf(candidateValue);
        if (expectNumbers && candidateType != JmesPathType.NUMBER) {
            throw new ArgumentTypeException(this.name(), "number", candidateType.toString());
        }
        if (!expectNumbers && candidateType != JmesPathType.STRING) {
            throw new ArgumentTypeException(this.name(), "string", candidateType.toString());
        }
    }
}

