/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.jcf;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.parser.JmesPathBaseVisitor;
import io.burt.jmespath.parser.JmesPathParser;
import io.burt.jmespath.parser.ParseErrorAccumulator;
import io.burt.jmespath.parser.ParseException;
import io.burt.jmespath.util.AntlrHelper;
import io.burt.jmespath.util.StringEscapeHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.tree.ParseTree;

public class JsonParser
extends JmesPathBaseVisitor<Object> {
    private static final StringEscapeHelper jsonEscapeHelper = new StringEscapeHelper(true, '\"', '\"', '/', '/', '\\', '\\', 'b', '\b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t');
    private final ParseTree tree;
    private final Adapter<Object> runtime;

    public static Object fromString(String json, Adapter<Object> runtime) {
        ParseErrorAccumulator errors = new ParseErrorAccumulator();
        JmesPathParser parser = AntlrHelper.createParser(json, (ANTLRErrorListener)errors);
        JmesPathParser.JsonValueContext tree = parser.jsonValue();
        if (errors.isEmpty()) {
            return new JsonParser((ParseTree)tree, runtime).object();
        }
        throw new ParseException(json, errors);
    }

    private JsonParser(ParseTree tree, Adapter<Object> runtime) {
        this.tree = tree;
        this.runtime = runtime;
    }

    public Object object() {
        return this.visit(this.tree);
    }

    private String unquote(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

    @Override
    public Object visitJsonObject(JmesPathParser.JsonObjectContext ctx) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>(ctx.jsonObjectPair().size());
        for (JmesPathParser.JsonObjectPairContext pair : ctx.jsonObjectPair()) {
            String key = jsonEscapeHelper.unescape(this.unquote(pair.STRING().getText()));
            Object value = this.visit((ParseTree)pair.jsonValue());
            object.put(key, value);
        }
        return this.runtime.createObject(object);
    }

    @Override
    public Object visitJsonArray(JmesPathParser.JsonArrayContext ctx) {
        ArrayList<Object> array = new ArrayList<Object>(ctx.jsonValue().size());
        for (JmesPathParser.JsonValueContext entry : ctx.jsonValue()) {
            array.add(this.visit((ParseTree)entry));
        }
        return this.runtime.createArray(array);
    }

    @Override
    public Object visitJsonStringValue(JmesPathParser.JsonStringValueContext ctx) {
        return this.runtime.createString(jsonEscapeHelper.unescape(this.unquote(ctx.getText())));
    }

    @Override
    public Object visitJsonNumberValue(JmesPathParser.JsonNumberValueContext ctx) {
        if (ctx.REAL_OR_EXPONENT_NUMBER() != null) {
            return this.runtime.createNumber(Double.parseDouble(ctx.getText()));
        }
        return this.runtime.createNumber(Long.parseLong(ctx.getText()));
    }

    @Override
    public Object visitJsonObjectValue(JmesPathParser.JsonObjectValueContext ctx) {
        return this.visit((ParseTree)ctx.jsonObject());
    }

    @Override
    public Object visitJsonArrayValue(JmesPathParser.JsonArrayValueContext ctx) {
        return this.visit((ParseTree)ctx.jsonArray());
    }

    @Override
    public Object visitJsonConstantValue(JmesPathParser.JsonConstantValueContext ctx) {
        switch (ctx.getText().charAt(0)) {
            case 't': {
                return this.runtime.createBoolean(true);
            }
            case 'f': {
                return this.runtime.createBoolean(false);
            }
            case 'n': {
                return this.runtime.createNull();
            }
        }
        throw new IllegalStateException(String.format("Expected true, false or null but encountered %s", ctx.getText()));
    }
}

