/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.function.FunctionCallException;

public class ArityException
extends FunctionCallException {
    public ArityException(String functionName, int minArity, int maxArity, int numArguments) {
        this(functionName, minArity, maxArity, numArguments, null);
    }

    public ArityException(String functionName, int minArity, int maxArity, int numArguments, Throwable cause) {
        super(ArityException.createMessage(functionName, minArity, maxArity, numArguments), cause);
    }

    private static String createMessage(String functionName, int minArity, int maxArity, int numArguments) {
        if (maxArity == minArity) {
            return String.format("Invalid arity calling \"%s\": expected %d but was %d", functionName, minArity, numArguments);
        }
        if (numArguments < minArity) {
            return String.format("Invalid arity calling \"%s\": expected at least %d but was %d", functionName, minArity, numArguments);
        }
        return String.format("Invalid arity calling \"%s\": expected at most %d but was %d", functionName, maxArity, numArguments);
    }
}

