/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.util;

import io.burt.jmespath.util.StringEscapeHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StringEscapeHelperTest {
    @Test
    public void nothingIsUnescapedByDefault() {
        StringEscapeHelper escapeHelper = new StringEscapeHelper(false, new char[0]);
        String unescaped = escapeHelper.unescape("hello\\u0020world\\n");
        Assert.assertThat((Object)unescaped, (Matcher)Matchers.is((Object)"hello\\u0020world\\n"));
    }

    @Test
    public void unicodeEscapesCanBeUnescaped() {
        StringEscapeHelper escapeHelper = new StringEscapeHelper(true, new char[0]);
        String unescaped = escapeHelper.unescape("hello\\u0020world\\u000a");
        Assert.assertThat((Object)unescaped, (Matcher)Matchers.is((Object)"hello world\n"));
    }

    @Test
    public void escapesAreReplacedByTheirReplacements() {
        StringEscapeHelper escapeHelper = new StringEscapeHelper(new char[]{'n', '\n', 't', '\t', 'x', '!'});
        String unescaped = escapeHelper.unescape("\\thello\\nworld\\x");
        Assert.assertThat((Object)unescaped, (Matcher)Matchers.is((Object)"\thello\nworld!"));
    }

    @Test
    public void replacementsMustBePairs() {
        try {
            new StringEscapeHelper(new char[]{'x', 'x', 'y'});
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertThat((Object)iae.getMessage(), (Matcher)Matchers.is((Object)"Replacements must be even pairs"));
        }
    }

    @Test
    public void specialCharsAreEscaped() {
        StringEscapeHelper escapeHelper = new StringEscapeHelper(new char[]{'n', '\n', 't', '\t', 'x', '!'});
        String escaped = escapeHelper.escape("\thello\nworld!");
        Assert.assertThat((Object)escaped, (Matcher)Matchers.is((Object)"\\thello\\nworld\\x"));
    }
}

