/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.parser;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jcf.JcfRuntime;
import io.burt.jmespath.node.CreateObjectNode;
import io.burt.jmespath.node.Node;
import io.burt.jmespath.node.Operator;
import io.burt.jmespath.parser.ParseError;
import io.burt.jmespath.parser.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    private Adapter<Object> runtime = new JcfRuntime();

    private Expression<Object> compile(String str) {
        return this.runtime.compile(str);
    }

    private Node<Object> Current() {
        return this.runtime.nodeFactory().createCurrent();
    }

    private Node<Object> Property(String name) {
        return this.runtime.nodeFactory().createProperty(name);
    }

    private Node<Object> Index(int index) {
        return this.runtime.nodeFactory().createIndex(index);
    }

    private Node<Object> Slice(Integer start, Integer stop, Integer step) {
        return this.runtime.nodeFactory().createSlice(start, stop, step);
    }

    private Node<Object> Projection(Expression<Object> expression) {
        return this.runtime.nodeFactory().createProjection(expression);
    }

    private Node<Object> FlattenArray() {
        return this.runtime.nodeFactory().createFlattenArray();
    }

    private Node<Object> FlattenObject() {
        return this.runtime.nodeFactory().createFlattenObject();
    }

    private Node<Object> Selection(Expression<Object> test) {
        return this.runtime.nodeFactory().createSelection(test);
    }

    private Node<Object> Comparison(String operator, Expression<Object> left, Expression<Object> right) {
        return this.runtime.nodeFactory().createComparison(Operator.fromString((String)operator), left, right);
    }

    private Node<Object> Or(Expression<Object> left, Expression<Object> right) {
        return this.runtime.nodeFactory().createOr(left, right);
    }

    private Node<Object> And(Expression<Object> left, Expression<Object> right) {
        return this.runtime.nodeFactory().createAnd(left, right);
    }

    private Node<Object> FunctionCall(String functionName, List<? extends Expression<Object>> args) {
        return this.runtime.nodeFactory().createFunctionCall(functionName, args);
    }

    private Node<Object> ExpressionReference(Expression<Object> expression) {
        return this.runtime.nodeFactory().createExpressionReference(expression);
    }

    private Node<Object> String(String str) {
        return this.runtime.nodeFactory().createString(str);
    }

    private Node<Object> Negate(Node<Object> negated) {
        return this.runtime.nodeFactory().createNegate(negated);
    }

    private Node<Object> Object(List<CreateObjectNode.Entry<Object>> entries) {
        return this.runtime.nodeFactory().createCreateObject(entries);
    }

    private Node<Object> Array(List<? extends Expression<Object>> entries) {
        return this.runtime.nodeFactory().createCreateArray(entries);
    }

    private Node<Object> JsonLiteral(String json) {
        return this.runtime.nodeFactory().createJsonLiteral(json);
    }

    private Node<Object> Sequence(Node<Object> first, Node<Object> second) {
        return this.runtime.nodeFactory().createSequence(Arrays.asList(first, second));
    }

    @Test
    public void identifierExpression() {
        Node<Object> expected = this.Property("foo");
        Expression<Object> actual = this.compile("foo");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void quotedIdentifierExpression() {
        Node<Object> expected = this.Property("foo-bar");
        Expression<Object> actual = this.compile("\"foo-bar\"");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void quotedIdentifierExpressionsAreUnescapedLikeJsonStrings() {
        Node<Object> expected = this.Property("\\foo bar\n");
        Expression<Object> actual = this.compile("\"\\\\foo\\u0020bar\\n\"");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Property("bar"));
        Expression<Object> actual = this.compile("foo.bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void longChainExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Sequence(this.Property("bar"), this.Sequence(this.Property("baz"), this.Property("qux"))));
        Expression<Object> actual = this.compile("foo.bar.baz.qux");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void pipeExpressionWithoutProjection() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Property("bar"));
        Expression<Object> actual = this.compile("foo | bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void longPipeExpressionWithoutProjection() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Sequence(this.Property("foo"), this.Property("bar")), this.Property("baz")), this.Property("qux"));
        Expression<Object> actual = this.compile("foo | bar | baz | qux");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void pipesAndChains() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("foo"), this.Property("bar")), this.Sequence(this.Property("baz"), this.Property("qux")));
        Expression<Object> actual = this.compile("foo.bar | baz.qux");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void indexExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Index(3));
        Expression<Object> actual = this.compile("foo[3]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareIndexExpression() {
        Node<Object> expected = this.Index(3);
        Expression<Object> actual = this.compile("[3]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(3, 4, 1));
        Expression<Object> actual = this.compile("foo[3:4]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithoutStopExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(3, null, 1));
        Expression<Object> actual = this.compile("foo[3:]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithoutStartExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(null, 4, 1));
        Expression<Object> actual = this.compile("foo[:4]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithStepExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(3, 4, 5));
        Expression<Object> actual = this.compile("foo[3:4:5]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithStepButWithoutStopExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(3, null, 5));
        Expression<Object> actual = this.compile("foo[3::5]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithJustColonExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(null, null, 1));
        Expression<Object> actual = this.compile("foo[:]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithJustTwoColonsExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(null, null, 1));
        Expression<Object> actual = this.compile("foo[::]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareSliceExpression() {
        Node<Object> expected = this.Slice(0, 1, 2);
        Expression<Object> actual = this.compile("[0:1:2]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceWithZeroStepSize() {
        try {
            this.compile("[0:1:0]");
            Assert.fail((String)"Expected ParseException to be thrown");
        }
        catch (ParseException pe) {
            Assert.assertThat((Object)pe.getMessage(), (Matcher)Matchers.is((Object)"Unable to compile expression \"[0:1:0]\": invalid value 0 for step size at position 5"));
        }
    }

    @Test
    public void flattenExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.FlattenArray());
        Expression<Object> actual = this.compile("foo[]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareFlattenExpression() {
        Node<Object> expected = this.FlattenArray();
        Expression<Object> actual = this.compile("[]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void listWildcardExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Projection((Expression<Object>)this.Current()));
        Expression<Object> actual = this.compile("foo[*]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareListWildcardExpression() {
        Node<Object> expected = this.Projection((Expression<Object>)this.Current());
        Expression<Object> actual = this.compile("[*]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void hashWildcardExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.FlattenObject());
        Expression<Object> actual = this.compile("foo.*");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareHashWildcardExpression() {
        Node<Object> expected = this.FlattenObject();
        Expression<Object> actual = this.compile("*");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void currentNodeExpression() {
        Node<Object> expected = this.Current();
        Expression<Object> actual = this.compile("@");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void currentNodeInPipes() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Sequence(this.Sequence(this.Current(), this.Property("foo")), this.Current()), this.Property("bar")), this.Current());
        Expression<Object> actual = this.compile("@ | foo | @ | bar | @");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void selectionExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Property("bar")));
        Expression<Object> actual = this.compile("foo[?bar]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void selectionWithConditionExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("bar"), (Expression<Object>)this.Property("baz"))));
        Expression<Object> actual = this.compile("foo[?bar == baz]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareSelection() {
        Node<Object> expected = this.Selection((Expression<Object>)this.Property("bar"));
        Expression<Object> actual = this.compile("[?bar]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void simpleFunctionCallExpression() {
        Node<Object> expected = this.FunctionCall("sort", Arrays.asList(this.Current()));
        Expression<Object> actual = this.compile("sort(@)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void functionCallWithArgumentExpression() {
        Node<Object> expected = this.FunctionCall("sort", Arrays.asList(this.Property("bar")));
        Expression<Object> actual = this.compile("sort(bar)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void functionCallWithMultipleArgumentsExpression() {
        Node<Object> expected = this.FunctionCall("merge", Arrays.asList(this.Property("bar"), this.Property("baz"), this.Current()));
        Expression<Object> actual = this.compile("merge(bar, baz, @)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainedFunctionCallExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.FunctionCall("to_string", Arrays.asList(this.Current())));
        Expression<Object> actual = this.compile("foo.to_string(@)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void functionCallWithExpressionReference() {
        Node<Object> expected = this.FunctionCall("sort", Arrays.asList(this.ExpressionReference((Expression<Object>)this.Sequence(this.Property("bar"), this.Property("bar")))));
        Expression<Object> actual = this.compile("sort(&bar.bar)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void functionCallWithUnknownFunction() {
        try {
            this.compile("to_unicorn(@)");
            Assert.fail((String)"Expected ParseException to be thrown");
        }
        catch (ParseException pe) {
            Assert.assertThat((Object)pe.getMessage(), (Matcher)Matchers.is((Object)"Unable to compile expression \"to_unicorn(@)\": unknown function \"to_unicorn\" at position 0"));
        }
    }

    @Test
    public void bareRawStringExpression() {
        Node<Object> expected = this.String("foo");
        Expression<Object> actual = this.compile("'foo'");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void rawStringComparisonExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Comparison("!=", (Expression<Object>)this.Property("bar"), (Expression<Object>)this.String("baz"))));
        Expression<Object> actual = this.compile("foo[?bar != 'baz']");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void andExpression() {
        Node<Object> expected = this.And((Expression<Object>)this.Property("foo"), (Expression<Object>)this.Property("bar"));
        Expression<Object> actual = this.compile("foo && bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void orExpression() {
        Node<Object> expected = this.Or((Expression<Object>)this.Property("foo"), (Expression<Object>)this.Property("bar"));
        Expression<Object> actual = this.compile("foo || bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void wildcardAfterPipe() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Projection((Expression<Object>)this.Current()));
        Expression<Object> actual = this.compile("foo | [*]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void indexAfterPipe() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Index(1));
        Expression<Object> actual = this.compile("foo | [1]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void sliceAfterPipe() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Slice(1, 2, 1));
        Expression<Object> actual = this.compile("foo | [1:2]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void flattenAfterPipe() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.FlattenArray());
        Expression<Object> actual = this.compile("foo | []");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void selectionAfterPipe() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Property("bar")));
        Expression<Object> actual = this.compile("foo | [?bar]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void booleanComparisonExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Or((Expression<Object>)this.And((Expression<Object>)this.Comparison("!=", (Expression<Object>)this.Property("bar"), (Expression<Object>)this.String("baz")), (Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("qux"), (Expression<Object>)this.String("fux"))), (Expression<Object>)this.Comparison(">", (Expression<Object>)this.Property("mux"), (Expression<Object>)this.String("lux")))));
        Expression<Object> actual = this.compile("foo[?bar != 'baz' && qux == 'fux' || mux > 'lux']");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainPipeFunctionCallCombination() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Sequence(this.Property("foo"), this.Property("bar")), this.FlattenArray()), this.FunctionCall("sort", Arrays.asList(this.Current())));
        Expression<Object> actual = this.compile("foo.bar[] | sort(@)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainPipeIndexSliceCombination() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("foo"), this.Sequence(this.Index(3), this.Property("bar"))), this.Sequence(this.Property("baz"), this.Sequence(this.Property("qux"), this.Slice(2, 3, 1))));
        Expression<Object> actual = this.compile("foo[3].bar | baz.qux[2:3]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareMultiSelectHashExpression() {
        Node<Object> expected = this.Object(Arrays.asList(new CreateObjectNode.Entry("foo", this.String("bar")), new CreateObjectNode.Entry("baz", this.Current())));
        Expression<Object> actual = this.compile("{foo: 'bar', baz: @}");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainedMultiSelectHashExpression() {
        Node<Object> expected = this.Sequence(this.Property("hello"), this.Sequence(this.Property("world"), this.Object(Arrays.asList(new CreateObjectNode.Entry("foo", this.String("bar")), new CreateObjectNode.Entry("baz", this.Current())))));
        Expression<Object> actual = this.compile("hello | world.{foo: 'bar', baz: @}");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainedMultiSelectHashWithQuotedKeys() {
        Node<Object> expected = this.Object(Arrays.asList(new CreateObjectNode.Entry("foo", this.String("bar")), new CreateObjectNode.Entry("baz", this.Current())));
        Expression<Object> actual = this.compile("{\"foo\": 'bar', \"baz\": @}");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void jmesPathSiteExampleExpression() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Sequence(this.Property("locations"), this.Sequence(this.Selection((Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("state"), (Expression<Object>)this.String("WA"))), this.Projection((Expression<Object>)this.Property("name")))), this.FunctionCall("sort", Arrays.asList(this.Current()))), this.Object(Arrays.asList(new CreateObjectNode.Entry("WashingtonCities", this.FunctionCall("join", Arrays.asList(this.String(", "), this.Current()))))));
        Expression<Object> actual = this.compile("locations[?state == 'WA'].name | sort(@) | {WashingtonCities: join(', ', @)}");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareMultiSelectListExpression() {
        Node<Object> expected = this.Array(Arrays.asList(this.String("bar"), this.Current()));
        Expression<Object> actual = this.compile("['bar', @]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainedMultiSelectListExpression() {
        Node<Object> expected = this.Sequence(this.Property("hello"), this.Sequence(this.Property("world"), this.Array(Arrays.asList(this.String("bar"), this.Current()))));
        Expression<Object> actual = this.compile("hello | world.['bar', @]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void parenthesizedPipeExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Sequence(this.Property("bar"), this.Property("baz")));
        Expression<Object> actual = this.compile("foo | (bar | baz)");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void parenthesizedComparisonExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.And((Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("bar"), (Expression<Object>)this.String("baz")), (Expression<Object>)this.Or((Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("qux"), (Expression<Object>)this.String("fux")), (Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("mux"), (Expression<Object>)this.String("lux"))))));
        Expression<Object> actual = this.compile("foo[?bar == 'baz' && (qux == 'fux' || mux == 'lux')]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareNegatedExpression() {
        Node<Object> expected = this.Negate(this.Property("foo"));
        Expression<Object> actual = this.compile("!foo");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void negatedSelectionExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Negate(this.Property("bar"))));
        Expression<Object> actual = this.compile("foo[?!bar]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralExpression() {
        Node<Object> expected = this.JsonLiteral("{}");
        Expression<Object> actual = this.compile("`{}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralArray() {
        Node<Object> expected = this.JsonLiteral("[]");
        Expression<Object> actual = this.compile("`[]`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralNumber() {
        Node<Object> expected = this.JsonLiteral("3.14");
        Expression<Object> actual = this.compile("`3.14`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralString() {
        Node<Object> expected = this.JsonLiteral("\"foo\"");
        Expression<Object> actual = this.compile("`\"foo\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralConstant() {
        Node<Object> expected = this.JsonLiteral("false");
        Expression<Object> actual = this.compile("`false`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralStringWithEscapedNewline() {
        Node<Object> expected = this.JsonLiteral("\"hello\nworld\"");
        Expression<Object> actual = this.compile("`\"hello\\nworld\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralStringWithEscapedTab() {
        Node<Object> expected = this.JsonLiteral("\"hello\tworld\"");
        Expression<Object> actual = this.compile("`\"hello\\tworld\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralStringWithEscapedUnicode() {
        Node<Object> expected = this.JsonLiteral("\"hello\\u0020world\"");
        Expression<Object> actual = this.compile("`\"hello world\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralStringWithEscapedQuote() {
        Node<Object> expected = this.JsonLiteral("\"hello \\\"world\\\"\"");
        Expression<Object> actual = this.compile("`\"hello \\\"world\\\"\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralStringWithEscapedBackslash() {
        Node<Object> expected = this.JsonLiteral("\"c:\\\\\\\\windows\\\\path\"");
        Expression<Object> actual = this.compile("`\"c:\\\\\\\\windows\\\\path\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralObjectWithEscapedNewlineInKey() {
        Node<Object> expected = this.JsonLiteral("{\"hello\nworld\":1}");
        Expression<Object> actual = this.compile("`{\"hello\\nworld\":1}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralObjectWithEscapedTabInKey() {
        Node<Object> expected = this.JsonLiteral("{\"hello\tworld\":1}");
        Expression<Object> actual = this.compile("`{\"hello\\tworld\":1}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralObjectWithEscapedUnicodeInKey() {
        Node<Object> expected = this.JsonLiteral("{\"hello\\u0020world\":1}");
        Expression<Object> actual = this.compile("`{\"hello world\":1}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralObjectWithEscapedQuoteInKey() {
        Node<Object> expected = this.JsonLiteral("{\"hello \\\"world\\\"\":1}");
        Expression<Object> actual = this.compile("`{\"hello \\\"world\\\"\":1}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void bareJsonLiteralObjectWithEscapedBackslashInKey() {
        Node<Object> expected = this.JsonLiteral("{\"c:\\\\\\\\windows\\\\path\":1}");
        Expression<Object> actual = this.compile("`{\"c:\\\\\\\\windows\\\\path\":1}`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void escapedBacktickInJsonString() {
        Node<Object> expected = this.JsonLiteral("\"fo`o\"");
        Expression<Object> actual = this.compile("`\"fo\\`o\"`");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void unEscapedBacktickInJsonString() {
        try {
            this.compile("`\"fo`o\"`");
            Assert.fail((String)"Expected ParseException to be thrown");
        }
        catch (ParseException pe) {
            Assert.assertThat((Object)pe.getMessage(), (Matcher)Matchers.is((Object)"Unable to compile expression \"`\"fo`o\"`\": syntax error unexpected ` at position 4"));
        }
        try {
            this.compile("`\"`foo\"`");
            Assert.fail((String)"Expected ParseException to be thrown");
        }
        catch (ParseException pe) {
            Assert.assertThat((Object)pe.getMessage(), (Matcher)Matchers.is((Object)"Unable to compile expression \"`\"`foo\"`\": syntax error unexpected ` at position 2"));
        }
    }

    @Test
    public void comparisonWithJsonLiteralExpression() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Selection((Expression<Object>)this.Comparison("==", (Expression<Object>)this.Property("bar"), (Expression<Object>)this.JsonLiteral("{\"foo\":\"bar\"}"))));
        Expression<Object> actual = this.compile("foo[?bar == `{\"foo\": \"bar\"}`]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void jsonBuiltinsAsNames() {
        Node<Object> expected = this.Sequence(this.Property("false"), this.Sequence(this.Property("null"), this.Property("true")));
        Expression<Object> actual = this.compile("false.null.true");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void escapesInRawStringsArePreserved() {
        Node<Object> expected = this.String("\\u03a6hello\\nworld\\t");
        Expression<Object> actual = this.compile("'\\u03a6hello\\nworld\\t'");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void singleQuotesNeedsToBeEscapedInRawStrings() {
        Node<Object> expected = this.String("'");
        Expression<Object> actual = this.compile("'\\''");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void backslashesMustBeEscapedInRawStrings() {
        Node<Object> expected = this.String("\\");
        Expression<Object> actual = this.compile("'\\\\'");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void singleLevelProjection() {
        Node<Object> expected = this.Sequence(this.Property("foo"), this.Sequence(this.FlattenObject(), this.Projection((Expression<Object>)this.Property("bar"))));
        Expression<Object> actual = this.compile("foo.*.bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void singleLevelProjectionWithPipe() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("foo"), this.Sequence(this.FlattenObject(), this.Projection((Expression<Object>)this.Property("bar")))), this.Property("baz"));
        Expression<Object> actual = this.compile("foo.*.bar | baz");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void multipleLevelsOfProjections() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("foo"), this.Sequence(this.Slice(null, null, null), this.Projection((Expression<Object>)this.Sequence(this.FlattenObject(), this.Projection((Expression<Object>)this.Property("bar")))))), this.Property("baz"));
        Expression<Object> actual = this.compile("foo[:].*.bar | baz");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void projectionAsFirstOperation1() {
        Node<Object> expected = this.Sequence(this.Property("Records"), this.Projection((Expression<Object>)this.Sequence(this.Property("userIdentity"), this.Array(Arrays.asList(this.Property("userName"), this.Sequence(this.Property("sessionContext"), this.Sequence(this.Property("attributes"), this.Property("mfaAuthenticated"))))))));
        Expression<Object> actual = this.compile("Records[*].userIdentity.[userName, sessionContext.attributes.mfaAuthenticated]");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void projectionAsFirstOperation2() {
        Node<Object> expected = this.Sequence(this.Property("Records"), this.Projection((Expression<Object>)this.Sequence(this.Property("requestParameters"), this.Property("keyName"))));
        Expression<Object> actual = this.compile("Records[*].requestParameters.keyName");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void projectionAndFlatten() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("Records"), this.Sequence(this.Index(0), this.Sequence(this.Property("responseElements"), this.Sequence(this.FlattenObject(), this.Projection((Expression<Object>)this.Property("items")))))), this.Sequence(this.FlattenArray(), this.Projection((Expression<Object>)this.Property("instanceId"))));
        Expression<Object> actual = this.compile("Records[0].responseElements.*.items[].instanceId");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void operationsAfterPipeAfterProjection() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("Records"), this.Selection((Expression<Object>)this.String(""))), this.Negate(this.Current()));
        Expression<Object> actual = this.compile("Records[?''] | !@");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void chainedParenthesis() {
        Node<Object> expected = this.Sequence(this.Sequence(this.Property("foo"), this.FlattenArray()), this.Property("bar"));
        Expression<Object> actual = this.compile("(foo[]).bar");
        Assert.assertThat(actual, (Matcher)Matchers.is(expected));
    }

    @Test
    public void parseExceptionsCanBeIterated() {
        try {
            this.compile("foo`bar ^ hello");
            Assert.fail((String)"Expected ParseException to have been thrown");
        }
        catch (ParseException pe) {
            int errorCount = 0;
            Iterator iterator = pe.iterator();
            while (iterator.hasNext()) {
                ParseError e = (ParseError)iterator.next();
                ++errorCount;
            }
            Assert.assertThat((Object)errorCount, (Matcher)Matchers.is((Object)2));
        }
    }
}

