/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.ArityException;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.function.FunctionConfigurationException;
import io.burt.jmespath.jcf.JcfRuntime;
import io.burt.jmespath.node.ExpressionReferenceNode;
import io.burt.jmespath.node.PropertyNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FunctionTest {
    private final Adapter<Object> runtime = new JcfRuntime();
    private final FunctionArgument<Object> expressionReference = FunctionArgument.of((Expression)new ExpressionReferenceNode(this.runtime, (Expression)new PropertyNode(this.runtime, "foo")));
    private Function heterogenousListOfFunction = new TestFunction("heterogenous_list", ArgumentConstraints.listOf((ArgumentConstraint[])new ArgumentConstraint[]{ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER), ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING), ArgumentConstraints.typeOf((JmesPathType)JmesPathType.BOOLEAN)})){};
    private Function typeOfFunction = new TestFunction("type_of", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER)){};
    private Function arrayOfFunction = new TestFunction("array_of", ArgumentConstraints.arrayOf((ArgumentConstraint)ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING))){};

    private List<FunctionArgument<Object>> createValueArguments(Object ... values) {
        ArrayList<FunctionArgument<Object>> arguments = new ArrayList<FunctionArgument<Object>>();
        for (Object value : values) {
            arguments.add((FunctionArgument<Object>)FunctionArgument.of((Object)value));
        }
        return arguments;
    }

    @Test
    public void nameMustEndWithFunction() {
        try {
            new BadName();
            Assert.fail((String)"No exception thrown");
        }
        catch (FunctionConfigurationException fce) {
            Assert.assertThat((Object)fce.getMessage(), (Matcher)Matchers.containsString((String)"must end with \"Function\""));
        }
    }

    @Test
    public void nameFromClassName() {
        Assert.assertThat((Object)new NameFromClassNameFunction().name(), (Matcher)Matchers.is((Object)"name_from_class_name"));
    }

    @Test
    public void heterogenousListOfRequiresEachArgumentToMatch() {
        this.heterogenousListOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(1L), this.runtime.createString("hello"), this.runtime.createBoolean(true)));
        try {
            this.heterogenousListOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(1L), this.runtime.createNumber(2L), this.runtime.createNumber(3L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.is((Object)"Invalid argument type calling \"heterogenous_list\": expected string but was number"));
        }
    }

    @Test
    public void heterogenousListOfWithTooFewArguments() {
        try {
            this.heterogenousListOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(1L), this.runtime.createString("hello")));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.is((Object)"Invalid arity calling \"heterogenous_list\": expected 3 but was 2"));
        }
    }

    @Test
    public void heterogenousListOfWithTooManyArguments() {
        try {
            this.heterogenousListOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(1L), this.runtime.createString("hello"), this.runtime.createBoolean(false), this.runtime.createNumber(4L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.is((Object)"Invalid arity calling \"heterogenous_list\": expected 3 but was 4"));
        }
    }

    @Test
    public void typeOfRequiresTheArgumentToHaveTheRightType() {
        this.typeOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L)));
        try {
            this.typeOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createString("hello")));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"type_of\": expected number but was string"));
        }
    }

    @Test
    public void typeOfDoesNotAcceptExpressions() {
        try {
            this.typeOfFunction.call(this.runtime, Arrays.asList(this.expressionReference));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"type_of\": expected number but was expression"));
        }
    }

    @Test
    public void typeOfRequiresExactlyOneArgument() {
        try {
            this.typeOfFunction.call(this.runtime, this.createValueArguments(new Object[0]));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"type_of\": expected 1 but was 0"));
        }
        try {
            this.typeOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L), this.runtime.createNumber(3L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"type_of\": expected 1 but was 2"));
        }
    }

    @Test
    public void typeOfWithMultipleTypesAcceptsEitherType() {
        TestFunction wantsStringBooleanOrNumberFunction = new TestFunction("wants_string_boolean_or_number", ArgumentConstraints.typeOf((JmesPathType[])new JmesPathType[]{JmesPathType.STRING, JmesPathType.BOOLEAN, JmesPathType.NUMBER})){};
        wantsStringBooleanOrNumberFunction.call(this.runtime, this.createValueArguments(this.runtime.createString("hello")));
        wantsStringBooleanOrNumberFunction.call(this.runtime, this.createValueArguments(this.runtime.createBoolean(true)));
        wantsStringBooleanOrNumberFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L)));
        try {
            wantsStringBooleanOrNumberFunction.call(this.runtime, this.createValueArguments(this.runtime.createNull()));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"wants_string_boolean_or_number\": expected string, boolean or number but was null"));
        }
    }

    @Test
    public void arrayOfRequiresAnArray() {
        this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createString("hello"), this.runtime.createString("world")))));
        try {
            this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.is((Object)"Invalid argument type calling \"array_of\": expected array of string but was number"));
        }
    }

    @Test
    public void arrayOfRequiresTheArraysElementsToMatchTheSubConstraint() {
        this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createString("hello"), this.runtime.createString("world")))));
        try {
            this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createNumber(3L)))));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.is((Object)"Invalid argument type calling \"array_of\": expected array of string but was array containing number"));
        }
        try {
            this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createString("foo"), this.runtime.createBoolean(true), this.runtime.createNumber(3L)))));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.is((Object)"Invalid argument type calling \"array_of\": expected array of string but was array containing string, boolean and number"));
        }
    }

    @Test
    public void arrayOfDoesNotAcceptExpressions() {
        try {
            this.arrayOfFunction.call(this.runtime, Arrays.asList(this.expressionReference));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.is((Object)"Invalid argument type calling \"array_of\": expected array of string but was expression"));
        }
    }

    @Test
    public void arrayOfAcceptsEmptyArray() {
        TestFunction wantsStringOrNumberArrayFunction = new TestFunction("wants_string_or_number_array", ArgumentConstraints.arrayOf((ArgumentConstraint)ArgumentConstraints.typeOf((JmesPathType[])new JmesPathType[]{JmesPathType.STRING, JmesPathType.NUMBER}))){};
        wantsStringOrNumberArrayFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(new Object[0]))));
    }

    @Test
    public void arrayOfRequiresAllElementsToBeOfTheSameType() {
        TestFunction wantsStringOrNumberArrayFunction = new TestFunction("wants_string_or_number_array", ArgumentConstraints.arrayOf((ArgumentConstraint)ArgumentConstraints.typeOf((JmesPathType[])new JmesPathType[]{JmesPathType.STRING, JmesPathType.NUMBER}))){};
        try {
            wantsStringOrNumberArrayFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createNumber(3L), this.runtime.createString("hello")))));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"wants_string_or_number_array\": expected array of string or number but was array containing number and string"));
        }
        try {
            wantsStringOrNumberArrayFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createNumber(3L), this.runtime.createString("hello"), this.runtime.createString("world"), this.runtime.createNull()))));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"wants_string_or_number_array\": expected array of string or number but was array containing number, string and null"));
        }
    }

    @Test
    public void arrayOfRequiresExactlyOneArgument() {
        try {
            this.arrayOfFunction.call(this.runtime, this.createValueArguments(new Object[0]));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"array_of\": expected 1 but was 0"));
        }
        try {
            this.arrayOfFunction.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createString("hello"))), this.runtime.createNumber(3L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"array_of\": expected 1 but was 2"));
        }
    }

    @Test
    public void anyValueAcceptsAnyValue() {
        TestFunction acceptsAnyValue = new TestFunction("accepts_any_value", ArgumentConstraints.anyValue()){};
        acceptsAnyValue.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L)));
        acceptsAnyValue.call(this.runtime, this.createValueArguments(this.runtime.createBoolean(false)));
        acceptsAnyValue.call(this.runtime, this.createValueArguments(this.runtime.createString("hello")));
        acceptsAnyValue.call(this.runtime, this.createValueArguments(this.runtime.createNull()));
        acceptsAnyValue.call(this.runtime, this.createValueArguments(this.runtime.createArray(Arrays.asList(this.runtime.createNull(), this.runtime.createBoolean(true)))));
    }

    @Test
    public void anyValueDoesNotAcceptExpressions() {
        TestFunction doesNotAcceptExpression = new TestFunction("does_not_accept_expression", ArgumentConstraints.anyValue()){};
        try {
            doesNotAcceptExpression.call(this.runtime, Arrays.asList(this.expressionReference));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"does_not_accept_expression\": expected any value but was expression"));
        }
    }

    @Test
    public void listOfAcceptsASpecifiedNumberOfValues() {
        TestFunction acceptsBetweenThreeAndTenValues = new TestFunction("hello", ArgumentConstraints.listOf((int)3, (int)10, (ArgumentConstraint)ArgumentConstraints.anyValue())){};
        acceptsBetweenThreeAndTenValues.call(this.runtime, this.createValueArguments(this.runtime.createNull(), this.runtime.createNumber(3L), this.runtime.createString("hello"), this.runtime.createBoolean(false)));
    }

    @Test
    public void listOfUsesASubConstraintToCheckEachArgument() {
        TestFunction acceptsNumbers = new TestFunction("accepts_numbers", ArgumentConstraints.listOf((int)3, (int)10, (ArgumentConstraint)ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER))){};
        acceptsNumbers.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L), this.runtime.createNumber(3L), this.runtime.createNumber(3L), this.runtime.createNumber(3L)));
        try {
            acceptsNumbers.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L), this.runtime.createNumber(3L), this.runtime.createString("foobar"), this.runtime.createNumber(3L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"accepts_numbers\": expected number but was string"));
        }
    }

    @Test
    public void listOfDoesNotAcceptExpressions() {
        TestFunction doesNotAcceptExpression = new TestFunction("hello", ArgumentConstraints.listOf((int)1, (int)3, (ArgumentConstraint)ArgumentConstraints.anyValue())){};
        try {
            List<FunctionArgument<Object>> arguments = this.createValueArguments(this.runtime.createNumber(3L));
            arguments.add(this.expressionReference);
            doesNotAcceptExpression.call(this.runtime, arguments);
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"hello\": expected any value but was expression"));
        }
    }

    @Test
    public void listOfNeedsTheMinimumAmountOfValues() {
        TestFunction acceptsBetweenThreeAndTenValues = new TestFunction("hello", ArgumentConstraints.listOf((int)3, (int)10, (ArgumentConstraint)ArgumentConstraints.anyValue())){};
        try {
            acceptsBetweenThreeAndTenValues.call(this.runtime, this.createValueArguments(this.runtime.createNull()));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"hello\": expected at least 3 but was 1"));
        }
    }

    @Test
    public void listOfAcceptsOnlyTheMaximumAmountOfValues() {
        TestFunction acceptsBetweenThreeAndTenValues = new TestFunction("hello", ArgumentConstraints.listOf((int)1, (int)3, (ArgumentConstraint)ArgumentConstraints.anyValue())){};
        try {
            acceptsBetweenThreeAndTenValues.call(this.runtime, this.createValueArguments(this.runtime.createNull(), this.runtime.createNull(), this.runtime.createNull(), this.runtime.createNull()));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArityException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)Matchers.containsString((String)"Invalid arity calling \"hello\": expected at most 3 but was 4"));
        }
    }

    @Test
    public void expressionAcceptsAnExpressionReference() {
        TestFunction acceptsExpression = new TestFunction("gief_expression", ArgumentConstraints.listOf((ArgumentConstraint[])new ArgumentConstraint[]{ArgumentConstraints.expression(), ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER)})){};
        acceptsExpression.call(this.runtime, Arrays.asList(this.expressionReference, FunctionArgument.of((Object)this.runtime.createNumber(3L))));
    }

    @Test
    public void expressionDoesNotAcceptAValue() {
        TestFunction acceptsExpression = new TestFunction("gief_expression", ArgumentConstraints.listOf((ArgumentConstraint[])new ArgumentConstraint[]{ArgumentConstraints.expression(), ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER)})){};
        try {
            acceptsExpression.call(this.runtime, this.createValueArguments(this.runtime.createNumber(3L), this.runtime.createNumber(4L)));
            Assert.fail((String)"No exception was thrown");
        }
        catch (ArgumentTypeException ate) {
            Assert.assertThat((Object)ate.getMessage(), (Matcher)Matchers.containsString((String)"Invalid argument type calling \"gief_expression\": expected expression but was number"));
        }
    }

    private static class NameFromClassNameFunction
    extends BaseFunction {
        public NameFromClassNameFunction() {
            super(ArgumentConstraints.anyValue());
        }

        protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
            return (T)runtime.createNull();
        }
    }

    private static class BadName
    extends BaseFunction {
        public BadName() {
            super(ArgumentConstraints.anyValue());
        }

        protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
            return null;
        }
    }

    private static class TestFunction
    extends BaseFunction {
        public TestFunction(String name, ArgumentConstraint argumentConstraints) {
            super(name, argumentConstraints);
        }

        protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
            return (T)runtime.createNull();
        }
    }
}

