/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.jcf.JcfRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FunctionRegistryTest {
    private static final List<String> DEFAULT_FUNCTION_NAMES = Arrays.asList("abs", "avg", "contains", "ceil", "ends_with", "floor", "join", "keys", "length", "map", "max", "max_by", "merge", "min", "min_by", "not_null", "reverse", "sort", "sort_by", "starts_with", "sum", "to_array", "to_string", "to_number", "type", "values");
    private final Adapter<Object> runtime = new JcfRuntime();

    private List<FunctionArgument<Object>> createValueArguments(Object ... values) {
        ArrayList<FunctionArgument<Object>> arguments = new ArrayList<FunctionArgument<Object>>();
        for (Object value : values) {
            arguments.add((FunctionArgument<Object>)FunctionArgument.of((Object)value));
        }
        return arguments;
    }

    @Test
    public void theDefaultRegistryContainsTheDefaultFunctions() {
        FunctionRegistry defaultRegistry = FunctionRegistry.defaultRegistry();
        for (String functionName : DEFAULT_FUNCTION_NAMES) {
            Assert.assertThat((Object)defaultRegistry.getFunction(functionName).name(), (Matcher)Matchers.is((Object)functionName));
        }
    }

    @Test
    public void aCustomRegistryDoesNotContainTheDefaultFunctions() {
        FunctionRegistry customRegistry = new FunctionRegistry(new Function[]{new TestFunction("foo", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING))});
        for (String functionName : DEFAULT_FUNCTION_NAMES) {
            Assert.assertThat((Object)customRegistry.getFunction(functionName), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void aCustomRegistryContainsTheProvidedFunctions() {
        FunctionRegistry customRegistry = new FunctionRegistry(new Function[]{new TestFunction("foo", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING)), new TestFunction("bar", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER))});
        Assert.assertThat((Object)customRegistry.getFunction("foo").name(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)customRegistry.getFunction("bar").name(), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void theLastFunctionIsUsedWhenThereAreDuplicatedNames() {
        FunctionRegistry customRegistry = new FunctionRegistry(new Function[]{new TestFunction("foo", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING)), new TestFunction("foo", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER))});
        Function function = customRegistry.getFunction("foo");
        Object result = function.call(this.runtime, this.createValueArguments(3L));
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)3L));
    }

    @Test
    public void extendIsUsedToCreateRegistriesWithExtraFunctions() {
        FunctionRegistry defaultRegistry = FunctionRegistry.defaultRegistry();
        FunctionRegistry extendedRegistry = defaultRegistry.extend(new Function[]{new TestFunction("foo", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING)), new TestFunction("bar", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.NUMBER))});
        for (String functionName : DEFAULT_FUNCTION_NAMES) {
            Assert.assertThat((Object)extendedRegistry.getFunction(functionName).name(), (Matcher)Matchers.is((Object)functionName));
        }
        Assert.assertThat((Object)extendedRegistry.getFunction("foo").name(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)extendedRegistry.getFunction("bar").name(), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void functionsCanBeOverriddenWithExtend() {
        FunctionRegistry defaultRegistry = FunctionRegistry.defaultRegistry();
        FunctionRegistry extendedRegistry = defaultRegistry.extend(new Function[]{new TestFunction("to_number", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING))});
        Function function = extendedRegistry.getFunction("to_number");
        Object result = function.call(this.runtime, this.createValueArguments("notanumber"));
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"notanumber"));
    }

    private static class TestFunction
    extends BaseFunction {
        public TestFunction(String name, ArgumentConstraint argumentConstraints) {
            super(name, argumentConstraints);
        }

        protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
            return (T)arguments.get(0).value();
        }
    }
}

