/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.ArityException;
import io.burt.jmespath.parser.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class JmesPathRuntimeTest<T> {
    protected T contact;
    protected T cloudtrail;

    protected abstract Adapter<T> runtime();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T loadExample(String path) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JmesPathRuntimeTest.class.getResourceAsStream(path), Charset.forName("UTF-8")));){
            String line;
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            T t = this.parse(buffer.toString());
            return t;
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Failed parsing %s", path), ioe);
        }
    }

    protected T search(String query, T input) {
        Expression expression = this.runtime().compile(query);
        return (T)expression.search(input);
    }

    protected T parse(String json) {
        return (T)this.runtime().parseString(json);
    }

    protected Matcher<T> jsonBoolean(final boolean b) {
        return new BaseMatcher<T>(){

            public boolean matches(Object n) {
                Object node = n;
                return JmesPathRuntimeTest.this.runtime().typeOf(node) == JmesPathType.BOOLEAN && JmesPathRuntimeTest.this.runtime().isTruthy(node) == b;
            }

            public void describeTo(Description description) {
                description.appendText("JSON boolean with value ").appendValue((Object)b);
            }
        };
    }

    protected Matcher<T> jsonNumber(final Number e) {
        return new BaseMatcher<T>(){

            public boolean matches(Object n) {
                Object actual = n;
                Object expected = JmesPathRuntimeTest.this.runtime().createNumber(e.doubleValue());
                return JmesPathRuntimeTest.this.runtime().typeOf(actual) == JmesPathType.NUMBER && JmesPathRuntimeTest.this.runtime().compare(actual, expected) == 0;
            }

            public void describeTo(Description description) {
                description.appendText("JSON number with value ").appendValue((Object)e);
            }
        };
    }

    protected Matcher<T> jsonNull() {
        return new BaseMatcher<T>(){

            public boolean matches(Object n) {
                Object node = n;
                return JmesPathRuntimeTest.this.runtime().typeOf(node) == JmesPathType.NULL;
            }

            public void describeTo(Description description) {
                description.appendText("JSON null");
            }
        };
    }

    protected Matcher<T> jsonString(final String str) {
        return new BaseMatcher<T>(){

            public boolean matches(Object n) {
                Object node = n;
                return JmesPathRuntimeTest.this.runtime().createString(str).equals(node);
            }

            public void describeTo(Description description) {
                description.appendText("JSON string with value ").appendValue((Object)str);
            }
        };
    }

    protected Matcher<T> jsonArrayOfStrings(final String ... strs) {
        return new BaseMatcher<T>(){

            public boolean matches(Object n) {
                List input = JmesPathRuntimeTest.this.runtime().toList(n);
                if (input.size() != strs.length) {
                    return false;
                }
                for (int i = 0; i < strs.length; ++i) {
                    if (JmesPathRuntimeTest.this.runtime().toString(input.get(i)).equals(strs[i])) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("JSON array ").appendValue((Object)strs);
            }
        };
    }

    @Before
    public void loadExamples() {
        this.contact = this.loadExample("/contact.json");
        this.cloudtrail = this.loadExample("/cloudtrail.json");
    }

    @Test
    public void topLevelProperty() {
        T result = this.search("lastName", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Smith")));
    }

    @Test
    public void chainProperty() {
        T result = this.search("address.state", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("NY")));
    }

    @Test
    public void propertyNotFound() {
        T result = this.search("address.country", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void nullValue() {
        T result = this.search("spouse", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void index() {
        T result = this.search("phoneNumbers[1].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("office")));
    }

    @Test
    public void negativeIndex() {
        T result = this.search("phoneNumbers[-2].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("office")));
    }

    @Test
    public void indexNotFound() {
        T result = this.search("phoneNumbers[3].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void negativeIndexNotFound() {
        T result = this.search("phoneNumbers[-4].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void indexOnNonArrayProducesNull() {
        T result = this.search("[0]", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void projection() {
        T result = this.search("phoneNumbers[*].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("home", "office", "mobile")));
    }

    @Test
    public void multiStepProjection() {
        T result = this.search("Records[*].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void projectionFiltersNull() {
        T result = this.search("Records[*].requestParameters.keyName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("mykeypair")));
    }

    @Test
    public void projectionOnNonArrayProducesNull() {
        T result = this.search("[*]", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void pipeStopsProjections() {
        T result = this.search("Records[*].userIdentity | [1].userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Bob")));
    }

    @Test
    public void projectionOnProjection() {
        T result = this.search("Records[*].responseElements.instancesSet.items[*].instanceId", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[[\"i-ebeaf9e2\"],[\"i-2e9faebe\"]]")));
    }

    @Test
    public void pipeStopsNestedProjections() {
        T result = this.search("Records[*].*.*.* | [2][0][0][] | [0].creationDate", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("2014-03-06T15:15:06Z")));
    }

    @Test
    public void literalString() {
        T result = this.search("'hello world'", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("hello world")));
    }

    @Test
    public void literalStringIgnoresSource() {
        T result = this.search("Records[*] | 'hello world'", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("hello world")));
    }

    public void flattenStartsProjection() {
        T result = this.search("Records[].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void flattenArray() {
        T nestedArray = this.parse("[[0, 1, 2]]");
        T result = this.search("[]", nestedArray);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[0, 1, 2]")));
    }

    @Test
    public void flattenNonArrayProducesNull() {
        T result = this.search("Records[0].userIdentity.userName[]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void flattenMultipleTimes() {
        T nestedArray = this.parse("[[0, 1, 2]]");
        T result = this.search("[][][][][][][][][][][][][]", nestedArray);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[0, 1, 2]")));
    }

    @Test
    public void flattenInProjection() {
        T nestedArray = this.parse("[{\"a\":[0]},{\"a\":[1]}]");
        T result = this.search("[*].a[]", nestedArray);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[0, 1]")));
    }

    @Test
    public void flattenObject() {
        T result = this.search("Records[0].userIdentity.*", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("IAMUser", "EX_PRINCIPAL_ID", "arn:aws:iam::123456789012:user/Alice", "EXAMPLE_KEY_ID_ALICE", "123456789012", "Alice")));
    }

    @Test
    public void flattenObjectCreatesProjection() {
        T result = this.search("Records[0].responseElements.*.items[].instanceId", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("i-ebeaf9e2")));
    }

    @Test
    public void multipleFlattenObject() {
        T nestedObject = this.parse("{\"a\":{\"aa\":{\"inner\":1}},\"b\":{\"bb\":{\"inner\":2}}}");
        T result = this.search("*.*", nestedObject);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[[{\"inner\":1}],[{\"inner\":2}]]")));
    }

    @Test
    public void multipleFlattenObjectWithFollowingProjection() {
        T nestedObject = this.parse("{\"a\":{\"aa\":{\"inner\":1}},\"b\":{\"bb\":{\"inner\":2}}}");
        T result1 = this.search("*.*.inner", nestedObject);
        Assert.assertThat(result1, (Matcher)Matchers.is(this.parse("[[1],[2]]")));
        T result = this.search("*.*.inner[]", nestedObject);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1,2]")));
    }

    @Test
    public void flattenNonObjectProducesNull() {
        T result = this.search("Records[0].responseElements.instancesSet.items.*", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void slice() {
        T result = this.search("Records[0].userIdentity.* | [1::2]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("EX_PRINCIPAL_ID", "EXAMPLE_KEY_ID_ALICE", "Alice")));
    }

    @Test
    public void sliceNotFound() {
        T result = this.search("Records[0].userIdentity.* | [99:]", this.cloudtrail);
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void negativeStopSlice() {
        T result = this.search("Records[0].userIdentity.* | [:-2]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("IAMUser", "EX_PRINCIPAL_ID", "arn:aws:iam::123456789012:user/Alice", "EXAMPLE_KEY_ID_ALICE")));
    }

    @Test
    public void negativeStartSlice() {
        T result = this.search("Records[0].userIdentity.* | [-3:4]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("EXAMPLE_KEY_ID_ALICE")));
    }

    @Test
    public void negativeStepSliceReversesOrder() {
        T result = this.search("@[::-1]", this.parse("[0, 1, 2, 3, 4]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[4, 3, 2, 1, 0]")));
    }

    @Test
    public void negativeStepSliceReversesOrderAndSlices() {
        T result1 = this.search("@[3:1:-1]", this.parse("[0, 1, 2, 3, 4]"));
        T result2 = this.search("@[3:0:-1]", this.parse("[0, 1, 2, 3, 4]"));
        T result3 = this.search("@[3::-1]", this.parse("[0, 1, 2, 3, 4]"));
        Assert.assertThat(result1, (Matcher)Matchers.is(this.parse("[3, 2]")));
        Assert.assertThat(result2, (Matcher)Matchers.is(this.parse("[3, 2, 1]")));
        Assert.assertThat(result3, (Matcher)Matchers.is(this.parse("[3, 2, 1, 0]")));
    }

    @Test
    public void negativeStepSliceReversesOrderAndSlicesAndHandlesOverflow() {
        T result = this.search("@[10:1:-1]", this.parse("[0, 1, 2, 3, 4]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[4, 3, 2]")));
    }

    @Test
    public void negativeStepSliceReversesOrderAndSkips() {
        T result = this.search("Records[0].userIdentity.* | [::-2]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "EXAMPLE_KEY_ID_ALICE", "EX_PRINCIPAL_ID")));
    }

    @Test
    public void negativeStepSliceWithOutOfBoundsNegativeStop() {
        T result = this.search("@[:-200:-1]", this.parse("[0, 1, 2, 3, 4]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[4, 3, 2, 1, 0]")));
    }

    @Test
    public void sliceStartsProjection() {
        T result = this.search("[:2].a", this.parse("[{\"a\":1},{\"a\":2},{\"a\":3}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1, 2]")));
    }

    @Test
    public void currentNodeReturnsInput() {
        T result = this.search("@", this.cloudtrail);
        Assert.assertThat((Object)this.runtime().toList(this.runtime().getProperty(result, "Records")), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void currentNodeAsNoOp() {
        T result = this.search("@ | Records[0].userIdentity | @ | userName | @ | @", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Alice")));
    }

    @Test
    public void andReturnsSecondOperandWhenFirstIsTruthy() {
        T result = this.search("Records[0].userIdentity.userName && Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Bob")));
    }

    @Test
    public void andReturnsFirstOperandWhenItIsFalsy() {
        T result = this.search("'' && Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("")));
    }

    @Test
    public void aLongChainOfAnds() {
        T result = this.search("@ && Records[2] && Records[2].responseElements && Records[2].responseElements.keyName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test
    public void orReturnsFirstOperandWhenItIsTruthy() {
        T result = this.search("Records[0].userIdentity.userName || Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Alice")));
    }

    @Test
    public void orReturnsSecondOperandWhenFirstIsFalsy() {
        T result = this.search("'' || Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("Bob")));
    }

    @Test
    public void aLongChainOfOrs() {
        T result = this.search("'' || Records[3] || Records[2].foobar || Records[2].responseElements.keyName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test
    public void selectionWithTrueTest() {
        T result = this.search("Records[?@]", this.cloudtrail);
        Assert.assertThat((Object)this.runtime().typeOf(result), (Matcher)Matchers.is((Object)JmesPathType.ARRAY));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void selectionWithBooleanProperty() {
        T result = this.search("Records[*] | [?userIdentity.sessionContext.attributes.mfaAuthenticated].eventTime", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("2014-03-06T17:10:34Z")));
    }

    @Test
    public void selectionWithFalseTest() {
        T result = this.search("Records[?'']", this.cloudtrail);
        Assert.assertThat((Object)this.runtime().typeOf(result), (Matcher)Matchers.is((Object)JmesPathType.ARRAY));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void selectionStartsProjection() {
        T result = this.search("Records[?@].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void selectionTestReferencingProperty() {
        T result = this.search("Records[*].responseElements | [?keyFingerprint]", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat((Object)this.runtime().typeOf(result), (Matcher)Matchers.is((Object)JmesPathType.ARRAY));
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.runtime().getProperty(elements.get(0), "keyName"), (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test
    public void selectionDoesNotSelectProjectionPutEachProjectedElement() {
        T result = this.search("Records[*].responseElements.keyName[?@]", this.cloudtrail);
        Assert.assertThat((Object)this.runtime().typeOf(result), (Matcher)Matchers.is((Object)JmesPathType.ARRAY));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void selectionOnNonArrayProducesNull() {
        T result = this.search("Records[0].userIdentity[?@]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void selectionWithComplexTest() {
        T result = this.search("Records[*] | [?userIdentity.userName == 'Bob' || responseElements.instancesSet.items[0].instanceId == 'i-ebeaf9e2'].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob")));
    }

    @Test
    public void compareEqualityWhenEqualProducesTrue() {
        T result = this.search("Records[0].userIdentity.userName == Records[2].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareEqualityWhenNotEqualProducesFalse() {
        T result = this.search("Records[0].userIdentity.userName == Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNonEqualityWhenEqualProducesFalse() {
        T result = this.search("Records[0].userIdentity.userName != Records[2].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNonEqualityWhenNotEqualProducesTrue() {
        T result = this.search("Records[0].userIdentity.userName != Records[1].userIdentity.userName", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersEqWhenEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code == currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersEqWhenNotEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code == previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersNotEqWhenEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code != currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersNotEqWhenNotEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code != previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersGtWhenGt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code > previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersGtWhenLt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState.code > currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersGteWhenGt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code >= previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersGteWhenEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code >= currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersGteWhenLt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState.code >= currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersLtWhenGt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code < previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersLtWhenLt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState.code < currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersLteWhenGt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code <= previousState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void compareNumbersLteWhenEq() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | currentState.code <= currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareNumbersLteWhenLt() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState.code <= currentState.code", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void compareGtWithNonNumberProducesNull() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState > currentState", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void compareGteWithNonNumberProducesNull() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState >= currentState", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void compareLtWithNonNumberProducesNull() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState < currentState", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void compareLteWithNonNumberProducesNull() {
        T result = this.search("Records[1].responseElements.instancesSet.items[0] | previousState <= currentState", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void negateSomethingTruthyProducesFalse() {
        T result = this.search("!'hello'", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void negateNullProducesTrue() {
        T result = this.search("!Records[3]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void negateEmptyStringProducesTrue() {
        T result = this.search("!''", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void negateEmptyArrayProducesTrue() {
        T result = this.search("Records[?''] | !@", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void createObject() {
        T result = this.search("{userNames: Records[*].userIdentity.userName, keyName: Records[2].responseElements.keyName}", this.cloudtrail);
        Object userNames = this.runtime().getProperty(result, "userNames");
        Object keyName = this.runtime().getProperty(result, "keyName");
        Assert.assertThat((Object)userNames, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
        Assert.assertThat((Object)keyName, (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test
    public void createObjectInPipe() {
        T result = this.search("Records[*].userIdentity | {userNames: [*].userName, anyUsedMfa: ([?sessionContext.attributes.mfaAuthenticated] | !!@)}", this.cloudtrail);
        Object userNames = this.runtime().getProperty(result, "userNames");
        Object anyUsedMfa = this.runtime().getProperty(result, "anyUsedMfa");
        Assert.assertThat((Object)userNames, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
        Assert.assertThat((Object)anyUsedMfa, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void createObjectInProjection() {
        T result = this.search("Records[*].userIdentity.{userName: userName, usedMfa: sessionContext.attributes.mfaAuthenticated}", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat((Object)this.runtime().getProperty(elements.get(0), "usedMfa"), (Matcher)Matchers.is(this.jsonNull()));
        Assert.assertThat((Object)this.runtime().getProperty(elements.get(1), "usedMfa"), (Matcher)Matchers.is(this.jsonNull()));
        Assert.assertThat((Object)this.runtime().getProperty(elements.get(2), "usedMfa"), (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void nestedCreateObject() {
        T result = this.search("Records[*].userIdentity | {users: {names: [*].userName}}", this.cloudtrail);
        Object names = this.runtime().getProperty(this.runtime().getProperty(result, "users"), "names");
        Assert.assertThat((Object)names, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void createObjectOnNullProducesNull() {
        T result = this.search("bork.{foo: bar}", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void createArray() {
        T result = this.search("[Records[*].userIdentity.userName, Records[2].responseElements.keyName]", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat(elements.get(0), (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
        Assert.assertThat(elements.get(1), (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test
    public void createArrayInPipe() {
        T result = this.search("Records[*].userIdentity | [[*].userName, ([?sessionContext.attributes.mfaAuthenticated] | !!@)]", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat(elements.get(0), (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
        Assert.assertThat(elements.get(1), (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void createArrayInProjection() {
        T result = this.search("Records[*].userIdentity.[userName, sessionContext.attributes.mfaAuthenticated]", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat(this.runtime().toList(elements.get(0)).get(1), (Matcher)Matchers.is(this.jsonNull()));
        Assert.assertThat(this.runtime().toList(elements.get(1)).get(1), (Matcher)Matchers.is(this.jsonNull()));
        Assert.assertThat(this.runtime().toList(elements.get(2)).get(1), (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void nestedCreateArray() {
        T result = this.search("Records[*].userIdentity | [[*].type, [[*].userName]]", this.cloudtrail);
        List elements = this.runtime().toList(result);
        Assert.assertThat(elements.get(0), (Matcher)Matchers.is(this.jsonArrayOfStrings("IAMUser", "IAMUser", "IAMUser")));
        Assert.assertThat(this.runtime().toList(elements.get(1)).get(0), (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void createArrayOnNullProducesNull() {
        T result = this.search("bork.[snork]", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void jsonLiteralNumber() {
        T result = this.search("`42`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("42")));
    }

    @Test
    public void jsonLiteralString() {
        T result = this.search("`\"foo\"`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("foo")));
    }

    @Test
    public void jsonLiteralStringWithEscapedBacktick() {
        T result = this.search("`\"fo\\`o\"`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("fo`o")));
    }

    @Test
    public void jsonLiteralBoolean() {
        T result = this.search("`true`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void jsonLiteralArray() {
        T result = this.search("`[42, \"foo\", true]`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[42, \"foo\", true]")));
    }

    @Test
    public void jsonLiteralObject() {
        T result = this.search("`{\"n\": 42, \"s\": \"foo\", \"b\": true}`", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"n\": 42, \"s\": \"foo\", \"b\": true}")));
    }

    @Test
    public void jsonLiteralInComparison() {
        T result = this.search("Records[?requestParameters == `{\"keyName\":\"mykeypair\"}`].sourceIPAddress", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("72.21.198.64")));
    }

    @Test
    public void numbersAreTruthy() {
        T result = this.search("!@", this.parse("1"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void stringsAreTruthy() {
        T result = this.search("!@", this.parse("\"foo\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void nonEmptyArraysAreTruthy() {
        T result = this.search("!@", this.parse("[\"foo\"]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void nonEmptyObjectsAreTruthy() {
        T result = this.search("!@", this.parse("{\"foo\":3}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void trueIsTruthy() {
        T result = this.search("!@", this.parse("true"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void falseIsNotTruthy() {
        T result = this.search("!@", this.parse("false"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void nullIsNotTruthy() {
        T result = this.search("!@", this.parse("null"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void anEmptyStringIsNotTruthy() {
        T result = this.search("!@", this.parse("\"\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void anEmptyArrayIsNotTruthy() {
        T result = this.search("!@", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void anEmptyObjectIsNotTruthy() {
        T result = this.search("!@", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void callFunction() {
        T result = this.search("type(@)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("object")));
    }

    @Test
    public void callFunctionWithExpressionReference() {
        T result = this.search("map(&userIdentity.userName, Records)", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("Alice", "Bob", "Alice")));
    }

    @Test
    public void callVariadicFunction() {
        T result = this.search("not_null(Records[0].requestParameters.keyName, Records[1].requestParameters.keyName, Records[2].requestParameters.keyName)", this.cloudtrail);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("mykeypair")));
    }

    @Test(expected=ParseException.class)
    public void callNonExistentFunctionThrowsParseException() {
        this.search("bork()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void callFunctionWithTooFewArgumentsThrowsArityException() {
        this.search("type()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void callFunctionWithTooManyArgumentsThrowsArityException() {
        this.search("type(@, @, @)", this.parse("{}"));
    }

    @Test
    public void absReturnsTheAbsoluteValueOfANumber() {
        T result1 = this.search("abs(`-1`)", this.parse("{}"));
        T result2 = this.search("abs(`1`)", this.parse("{}"));
        Assert.assertThat(result1, (Matcher)Matchers.is(this.jsonNumber(1)));
        Assert.assertThat(result2, (Matcher)Matchers.is(this.jsonNumber(1)));
    }

    @Test(expected=ArgumentTypeException.class)
    public void absRequiresANumberArgument() {
        this.search("abs('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void absRequiresExactlyOneArgument() {
        this.search("abs(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void absRequiresAValue() {
        this.search("abs(&foo)", this.parse("{}"));
    }

    @Test
    public void avgReturnsTheAverageOfAnArrayOfNumbers() {
        T result = this.search("avg(`[0, 1, 2, 3.5, 4]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(2.1)));
    }

    @Test
    public void avgReturnsNullWhenGivenAnEmptyArray() {
        T result = this.search("avg(`[]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void avgRequiresAnArrayOfNumbers() {
        this.search("avg('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void avgRequiresExactlyOneArgument() {
        this.search("avg(`[]`, `[]`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void avgRequiresAValue() {
        this.search("avg(&foo)", this.parse("{}"));
    }

    @Test
    public void containsReturnsTrueWhenTheNeedleIsFoundInTheHaystack() {
        T result = this.search("contains(@, `3`)", this.parse("[1, 2, 3, \"foo\"]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void containsComparesDeeply() {
        T result = this.search("contains(@, `[\"bar\", {\"baz\": 42}]`)", this.parse("[1, 2, 3, \"foo\", [\"bar\", {\"baz\": 42}]]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void containsReturnsFalseWhenTheNeedleIsNotFoundInTheHaystack() {
        T result = this.search("contains(@, `4`)", this.parse("[1, 2, 3, \"foo\"]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test
    public void containsSearchesInStrings() {
        T result = this.search("contains('hello', 'hell')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test(expected=ArityException.class)
    public void containsRequiresTwoArguments() {
        this.search("contains(@)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void containsRequiresAnArrayOrStringAsFirstArgument() {
        this.search("contains(@, 'foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void containsRequiresTwoArguments1() {
        this.search("contains('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void containsRequiresTwoArguments2() {
        this.search("contains('foo', 'bar', 'baz')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void containsRequiresValues1() {
        this.search("contains(@, &foo)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void containsRequiresValues2() {
        this.search("contains(&foo, 'bar')", this.parse("{}"));
    }

    @Test
    public void ceilReturnsTheNextWholeNumber() {
        T result1 = this.search("ceil(`0.9`)", this.parse("{}"));
        T result2 = this.search("ceil(`33.3`)", this.parse("{}"));
        Assert.assertThat(result1, (Matcher)Matchers.is(this.jsonNumber(1)));
        Assert.assertThat(result2, (Matcher)Matchers.is(this.jsonNumber(34)));
    }

    @Test(expected=ArgumentTypeException.class)
    public void ceilRequiresANumberArgument() {
        this.search("ceil('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void ceilRequiresExactlyOneArgument() {
        this.search("ceil(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void ceilRequiresAValue() {
        this.search("ceil(&foo)", this.parse("{}"));
    }

    @Test
    public void endsWithReturnsTrueWhenTheFirstArgumentEndsWithTheSecond() {
        T result = this.search("ends_with(@, 'rld')", this.parse("\"world\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void endsWithReturnsFalseWhenTheFirstArgumentDoesNotEndWithTheSecond() {
        T result = this.search("ends_with(@, 'rld')", this.parse("\"hello\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test(expected=ArityException.class)
    public void endsWithRequiresTwoArguments() {
        this.search("ends_with('')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void endsWithRequiresAStringAsFirstArgument() {
        this.search("ends_with(@, 'foo')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void endsWithRequiresAStringAsSecondArgument() {
        this.search("ends_with('foo', @)", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void endsWithRequiresTwoArguments1() {
        this.search("ends_with('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void endsWithRequiresTwoArguments2() {
        this.search("ends_with('foo', 'bar', @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void endsWithRequiresAValue1() {
        this.search("ends_with(&foo, 'bar')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void endsWithRequiresAValue2() {
        this.search("ends_with('foo', &bar)", this.parse("{}"));
    }

    @Test
    public void floorReturnsThePreviousWholeNumber() {
        T result1 = this.search("floor(`0.9`)", this.parse("{}"));
        T result2 = this.search("floor(`33.3`)", this.parse("{}"));
        Assert.assertThat(result1, (Matcher)Matchers.is(this.jsonNumber(0)));
        Assert.assertThat(result2, (Matcher)Matchers.is(this.jsonNumber(33)));
    }

    @Test(expected=ArgumentTypeException.class)
    public void floorRequiresANumberArgument() {
        this.search("floor('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void floorRequiresExactlyOneArgument() {
        this.search("floor(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void floorRequiresAValue() {
        this.search("floor(&foo)", this.parse("{}"));
    }

    @Test
    public void joinSmashesAnArrayOfStringsTogether() {
        T result = this.search("join('|', @)", this.parse("[\"foo\", \"bar\", \"baz\"]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("foo|bar|baz")));
    }

    @Test
    public void joinHandlesDuplicates() {
        Object string = this.runtime().createString("foo");
        Object value = this.runtime().createArray(Arrays.asList(string, string, string));
        Object result = this.search("join('|', @)", value);
        Assert.assertThat((Object)result, (Matcher)Matchers.is(this.jsonString("foo|foo|foo")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void joinRequiresAStringAsFirstArgument() {
        this.search("join(`3`, @)", this.parse("[\"foo\", 3, \"bar\", \"baz\"]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void joinRequiresAStringArrayAsSecondArgument() {
        this.search("join('|', @)", this.parse("[\"foo\", 3, \"bar\", \"baz\"]"));
    }

    @Test(expected=ArityException.class)
    public void joinRequiresTwoArguments1() {
        this.search("join('|')", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void joinRequiresTwoArguments2() {
        this.search("join('|', @, @)", this.parse("[]"));
    }

    @Test
    public void joinWithAnEmptyArrayReturnsAnEmptyString() {
        T result = this.search("join('|', @)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void joinRequiresAValue1() {
        this.search("join(&foo, @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void joinRequiresAValue2() {
        this.search("join('foo', &bar)", this.parse("{}"));
    }

    @Test
    public void keysReturnsTheNamesOfAnObjectsProperties() {
        T result = this.search("keys(@)", this.parse("{\"foo\":3,\"bar\":4}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("foo", "bar")));
    }

    @Test
    public void keysReturnsAnEmptyArrayWhenGivenAnEmptyObject() {
        T result = this.search("keys(@)", this.parse("{}"));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[]")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void keysRequiresAnObjectAsArgument() {
        this.search("keys(@)", this.parse("[3]"));
    }

    @Test(expected=ArityException.class)
    public void keysRequiresASingleArgument() {
        this.search("keys(@, @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void keysRequiresAValue() {
        this.search("keys(&foo)", this.parse("{}"));
    }

    @Test
    public void keysCanBeUsedInComparisons() {
        T result = this.search("keys(@) == `[\"foo\",\"bar\"]`", this.parse("{\"foo\":3,\"bar\":2}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void lengthReturnsTheLengthOfAString() {
        T result = this.search("length(foo)", this.parse("{\"foo\":\"bar\"}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(3)));
    }

    @Test
    public void lengthReturnsTheSizeOfAnArray() {
        T result = this.search("length(foo)", this.parse("{\"foo\":[0, 1, 2, 3]}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(4)));
    }

    @Test
    public void lengthReturnsTheSizeOfAnObject() {
        T result = this.search("length(@)", this.parse("{\"foo\":[0, 1, 2, 3]}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(1)));
    }

    @Test
    public void lengthCanBeUsedInComparisons() {
        T result = this.search("length(@) == `3`", this.parse("[0, 1, 2]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test(expected=ArgumentTypeException.class)
    public void lengthRequiresAStringArrayOrObjectAsArgument() {
        this.search("length(@)", this.parse("3"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void lengthRequiresAValue() {
        this.search("length(&foo)", this.parse("{}"));
    }

    @Test
    public void mapTransformsAnArrayIntoAnAnotherArrayByApplyingAnExpressionToEachElement() {
        T result = this.search("map(&type, phoneNumbers)", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("home", "office", "mobile")));
    }

    @Test
    public void mapReturnsAnEmptyArrayWhenGivenAnEmptyArray() {
        T result = this.search("map(&foo, @)", this.parse("[]"));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void mapAcceptsAnArrayOfObjects() {
        T result = this.search("map(&a, @)", this.parse("[{\"a\":1},{\"a\":2}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1,2]")));
    }

    @Test
    public void mapAcceptsAnArrayOfArrays() {
        T result = this.search("map(&[], @)", this.parse("[[1, 2, 3, [4]], [5, 6, 7, [8, 9]]]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[[1, 2, 3, 4], [5, 6, 7, 8, 9]]")));
    }

    @Test
    public void mapAcceptsAnArrayOfNumbers() {
        T result = this.search("map(&to_string(@), @)", this.parse("[1, -2, 3]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[\"1\", \"-2\", \"3\"]")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mapRequiresAnExpressionAsFirstArgument() {
        this.search("map(@, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mapRequiresAnArrayAsSecondArgument1() {
        this.search("map(&foo, @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mapRequiresAnArrayAsSecondArgument2() {
        this.search("map(@, &foo)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void mapRequiresTwoArguments1() {
        this.search("map(&foo.bar)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void mapRequiresTwoArguments2() {
        this.search("map(&foo.bar, @, @)", this.parse("[]"));
    }

    @Test
    public void maxReturnsTheGreatestOfAnArrayOfNumbers() {
        T result = this.search("max(`[0, 1, 4, 3.5, 2]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(4)));
    }

    @Test
    public void maxReturnsTheGreatestOfAnArrayOfStrings() {
        T result = this.search("max(`[\"a\", \"d\", \"b\"]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("d")));
    }

    @Test
    public void maxReturnsNullWhenGivenAnEmptyArray() {
        T result = this.search("max(`[]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxRequiresAnArrayOfNumbersOrStrings() {
        this.search("max('foo')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxRequiresTheElementsToBeOfTheSameType() {
        this.search("max(`[\"foo\", 1]`)", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void maxRequiresExactlyOneArgument() {
        this.search("max(`[]`, `[]`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxRequiresAValue() {
        this.search("max(&foo)", this.parse("{}"));
    }

    @Test
    public void maxByReturnsTheElementWithTheGreatestValueForAnExpressionThatReturnsStrings() {
        T result = this.search("max_by(phoneNumbers, &type)", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"type\": \"office\", \"number\": \"646 555-4567\"}")));
    }

    @Test
    public void maxByReturnsTheElementWithTheGreatestValueForAnExpressionThatReturnsNumbers() {
        T result = this.search("max_by(@, &foo)", this.parse("[{\"foo\": 3}, {\"foo\": 6}, {\"foo\": 1}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"foo\": 6}")));
    }

    @Test
    public void maxByReturnsWithAnEmptyArrayReturnsNull() {
        T result = this.search("max_by(@, &foo)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxByDoesNotAcceptMixedResults() {
        this.search("max_by(@, &foo)", this.parse("[{\"foo\": 3}, {\"foo\": \"bar\"}, {\"foo\": 1}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxByDoesNotAcceptNonStringsOrNumbers() {
        this.search("max_by(@, &foo)", this.parse("[{\"foo\": []}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxByRequiresAnArrayAsFirstArgument1() {
        this.search("max_by(@, &foo)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxByRequiresAnArrayAsFirstArgument2() {
        this.search("max_by(&foo, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void maxByRequiresAnExpressionAsSecondArgument() {
        this.search("max_by(@, @)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void maxByRequiresTwoArguments1() {
        this.search("max_by(@)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void maxByRequiresTwoArguments2() {
        this.search("max_by(@, &foo, @)", this.parse("[]"));
    }

    @Test
    public void mergeMergesObjects() {
        T result = this.search("merge(foo, bar)", this.parse("{\"foo\": {\"a\": 1, \"b\": 1}, \"bar\": {\"b\": 2}}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"a\": 1, \"b\": 2}")));
    }

    @Test
    public void mergeReturnsTheArgumentWhenOnlyGivenOne() {
        T result = this.search("merge(foo)", this.parse("{\"foo\": {\"a\": 1, \"b\": 1}, \"bar\": {\"b\": 2}}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"a\": 1, \"b\": 1}}")));
    }

    @Test
    public void mergeDoesNotMutate() {
        T result = this.search("merge(foo, bar) && foo", this.parse("{\"foo\": {\"a\": 1, \"b\": 1}, \"bar\": {\"b\": 2}}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"a\": 1, \"b\": 1}")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mergeRequiresObjectArguments1() {
        this.search("merge('foo', 'bar')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mergeRequiresObjectArguments2() {
        this.search("merge(`{}`, @)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void mergeRequiresAtLeastOneArgument() {
        this.search("merge()", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void mergeRequiresAValue() {
        this.search("merge(&foo)", this.parse("{}"));
    }

    @Test
    public void minReturnsTheGreatestOfAnArrayOfNumbers() {
        T result = this.search("min(`[0, 1, -4, 3.5, 2]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(-4)));
    }

    @Test
    public void minReturnsTheGreatestOfAnArrayOfStrings() {
        T result = this.search("min(`[\"foo\", \"bar\"]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("bar")));
    }

    @Test
    public void minReturnsNullWhenGivenAnEmptyArray() {
        T result = this.search("min(`[]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minRequiresAnArrayOfNumbersOrStrings() {
        this.search("min('foo')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minRequiresTheElementsToBeOfTheSameType() {
        this.search("min(`[\"foo\", 1]`)", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void minRequiresExactlyOneArgument() {
        this.search("min(`[]`, `[]`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minRequiresAValue() {
        this.search("min(&foo)", this.parse("{}"));
    }

    @Test
    public void minByReturnsTheElementWithTheLeastValueForAnExpressionThatReturnsStrings() {
        T result = this.search("min_by(phoneNumbers, &type)", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"type\": \"home\",\"number\": \"212 555-1234\"}")));
    }

    @Test
    public void minByReturnsTheElementWithTheLeastValueForAnExpressionThatReturnsNumbers() {
        T result = this.search("min_by(@, &foo)", this.parse("[{\"foo\": 3}, {\"foo\": -6}, {\"foo\": 1}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("{\"foo\": -6}")));
    }

    @Test
    public void minByReturnsWithAnEmptyArrayReturnsNull() {
        T result = this.search("min_by(@, &foo)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minByDoesNotAcceptMixedResults() {
        this.search("min_by(@, &foo)", this.parse("[{\"foo\": 3}, {\"foo\": \"bar\"}, {\"foo\": 1}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minByDoesNotAcceptNonStringsOrNumbers() {
        this.search("min_by(@, &foo)", this.parse("[{\"foo\": []}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minByRequiresAnArrayAsFirstArgument1() {
        this.search("min_by(@, &foo)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minByRequiresAnArrayAsFirstArgument2() {
        this.search("min_by(&foo, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void minByRequiresAnExpressionAsSecondArgument() {
        this.search("min_by(@, @)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void minByRequiresTwoArguments1() {
        this.search("min_by(@)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void minByRequiresTwoArguments2() {
        this.search("min_by(@, &foo, @)", this.parse("[]"));
    }

    @Test
    public void notNullReturnsTheFirstNonNullArgument() {
        T result = this.search("not_null(`null`, `null`, `3`, `null`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(3)));
    }

    @Test
    public void notNullReturnsNullWhenGivenOnlyNull() {
        T result = this.search("not_null(`null`, `null`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArityException.class)
    public void notNullRequiresAtLeastOneArgument() {
        this.search("not_null()", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void notNullRequiresAValue() {
        this.search("not_null(`null`, &foo)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void notNullRequiresAValueForArgumentsThatAreNotInspected() {
        this.search("not_null('foo', &foo)", this.parse("{}"));
    }

    @Test
    public void reverseReversesAnArray() {
        T result = this.search("reverse(@)", this.parse("[\"foo\", 3, 2, 1]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1, 2, 3, \"foo\"]")));
    }

    @Test
    public void reverseReturnsAnEmptyArrayWhenGivenAnEmptyArray() {
        T result = this.search("reverse(@)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[]")));
    }

    @Test
    public void reverseReversesAString() {
        T result = this.search("reverse('hello world')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("dlrow olleh")));
    }

    @Test
    public void reverseReturnsAnEmptyStringWhenGivenAnEmptyString() {
        T result = this.search("reverse('')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("")));
    }

    @Test(expected=ArityException.class)
    public void reverseRequiresOneArgument1() {
        this.search("reverse()", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void reverseRequiresOneArgument2() {
        this.search("reverse(@, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void reverseRequiresAnArrayAsArgument() {
        this.search("reverse(@)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void reverseRequiresAValue() {
        this.search("reverse(&foo)", this.parse("{}"));
    }

    @Test
    public void sortsSortsAnArrayOfNumbers() {
        T result = this.search("sort(@)", this.parse("[6, 7, 1]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1, 6, 7]")));
    }

    @Test
    public void sortsHandlesDuplicates() {
        T result = this.search("sort(@)", this.parse("[6, 6, 7, 1, 1]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[1, 1, 6, 6, 7]")));
    }

    @Test
    public void sortsSortsAnArrayOfStrings() {
        T result = this.search("sort(@)", this.parse("[\"b\", \"a\", \"x\"]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[\"a\", \"b\", \"x\"]")));
    }

    @Test
    public void sortReturnsAnEmptyArrayWhenGivenAnEmptyArray() {
        T result = this.search("sort(@)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[]")));
    }

    @Test(expected=ArityException.class)
    public void sortRequiresOneArgument1() {
        this.search("sort()", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void sortRequiresOneArgument2() {
        this.search("sort(@, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortRequiresAnArrayAsArgument() {
        this.search("sort(@)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortDoesNotAcceptMixedInputs() {
        this.search("sort(@)", this.parse("[1, \"foo\"]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortRequiresAValue() {
        this.search("sort(&foo)", this.parse("{}"));
    }

    @Test
    public void sortBySortsTheInputBasedOnStringsReturnedByAnExpression() {
        T result = this.search("sort_by(phoneNumbers, &type)[*].type", this.contact);
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("home", "mobile", "office")));
    }

    @Test
    public void sortBySortsTheInputBasedOnNumbersReturnedByAnExpression() {
        T result = this.search("sort_by(@, &foo)[*].foo", this.parse("[{\"foo\": 3}, {\"foo\": -6}, {\"foo\": 1}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[-6, 1, 3]")));
    }

    @Test
    public void sortByHandlesDuplicates() {
        T result = this.search("sort_by(@, &foo)[*].foo", this.parse("[{\"foo\": 3}, {\"foo\": -6}, {\"foo\": -6}, {\"foo\": 1}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[-6, -6, 1, 3]")));
    }

    @Test
    public void sortBySortsIsStable() {
        T result = this.search("sort_by(@, &foo)[*].x", this.parse("[{\"foo\": 3, \"x\": 3}, {\"foo\": 3, \"x\": 1}, {\"foo\": 1}]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[3, 1]")));
    }

    @Test
    public void sortByReturnsWithAnEmptyArrayReturnsNull() {
        T result = this.search("sort_by(@, &foo)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[]")));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortByDoesNotAcceptMixedResults() {
        this.search("sort_by(@, &foo)", this.parse("[{\"foo\": 3}, {\"foo\": \"bar\"}, {\"foo\": 1}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortByDoesNotAcceptNonStringsOrNumbers() {
        this.search("sort_by(@, &foo)", this.parse("[{\"foo\": []}]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortByRequiresAnArrayAsFirstArgument1() {
        this.search("sort_by(@, &foo)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortByRequiresAnArrayAsFirstArgument2() {
        this.search("sort_by(&foo, @)", this.parse("[]"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sortByRequiresAnExpressionAsSecondArgument() {
        this.search("sort_by(@, @)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void sortByRequiresTwoArguments1() {
        this.search("sort_by(@)", this.parse("[]"));
    }

    @Test(expected=ArityException.class)
    public void sortByRequiresTwoArguments2() {
        this.search("sort_by(@, &foo, @)", this.parse("[]"));
    }

    @Test
    public void startsWithReturnsTrueWhenTheFirstArgumentEndsWithTheSecond() {
        T result = this.search("starts_with(@, 'wor')", this.parse("\"world\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void startsWithReturnsFalseWhenTheFirstArgumentDoesNotEndWithTheSecond() {
        T result = this.search("starts_with(@, 'wor')", this.parse("\"hello\""));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonBoolean(false)));
    }

    @Test(expected=ArityException.class)
    public void startsWithRequiresTwoArguments() {
        this.search("starts_with('')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void startsWithRequiresAStringAsFirstArgument() {
        this.search("starts_with(@, 'foo')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void startsWithRequiresAStringAsSecondArgument() {
        this.search("starts_with('foo', @)", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void startsWithRequiresTwoArguments1() {
        this.search("starts_with('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void startsWithRequiresTwoArguments2() {
        this.search("starts_with('foo', 'bar', @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void startsWithRequiresAValue1() {
        this.search("starts_with(&foo, 'bar')", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void startsWithRequiresAValue2() {
        this.search("starts_with('foo', &bar)", this.parse("{}"));
    }

    @Test
    public void sumReturnsTheAverageOfAnArrayOfNumbers() {
        T result = this.search("sum(`[0, 1, 2, 3.5, 4]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(10.5)));
    }

    @Test
    public void sumReturnsZeroWhenGivenAnEmptyArray() {
        T result = this.search("sum(`[]`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(0)));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sumRequiresAnArrayOfNumbers() {
        this.search("sum('foo')", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void sumRequiresExactlyOneArgument() {
        this.search("sum(`[]`, `[]`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void sumRequiresAValue() {
        this.search("sum(&foo)", this.parse("{}"));
    }

    @Test
    public void toArrayReturnsASingletonArrayWithTheArgument() {
        T result = this.search("to_array(`34`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[34]")));
    }

    @Test
    public void toArrayWithAnArrayReturnsTheArgument() {
        T result = this.search("to_array(@)", this.parse("[0, 1, 2, 3.5, 4]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.parse("[0, 1, 2, 3.5, 4]")));
    }

    @Test(expected=ArityException.class)
    public void toArrayRequiresExactlyOneArgument1() {
        this.search("to_array()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void toArrayRequiresExactlyOneArgument2() {
        this.search("to_array(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void toArrayRequiresAValue() {
        this.search("to_array(&foo)", this.parse("{}"));
    }

    @Test
    public void toStringReturnsTheJsonEncodingOfTheArgument() {
        T input = this.parse("{\"foo\": [1, 2, [\"bar\"], false], \"bar\": null}");
        T result = this.search("to_string(@)", input);
        Assert.assertThat((Object)this.runtime().toString(result), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"\"foo\"")).and(Matchers.is((Object)this.runtime().toString(input))));
    }

    @Test
    public void toStringReturnsTheJsonEncodingOfNull() {
        T result = this.search("to_string(`null`)", this.parse("{}"));
        Assert.assertThat((Object)this.runtime().toString(result), (Matcher)Matchers.is((Object)"null"));
    }

    @Test
    public void toStringEncodesNewlinesTabsEtc1() {
        Object result = this.search("to_string(@)", this.runtime().createArray(Arrays.asList(this.runtime().createString("\"Hello\"\nwo\r\\ld\t"))));
        Assert.assertThat((Object)this.runtime().toString(result), (Matcher)Matchers.is((Object)"[\"\\\"Hello\\\"\\nwo\\r\\\\ld\\t\"]"));
    }

    @Test
    public void toStringEncodesNewlinesTabsEtc2() {
        Object result = this.search("to_string(@)", this.runtime().createObject(Collections.singletonMap(this.runtime().createString("\"Hello\"\nwo\r\\ld\t"), this.runtime().createString("\n\r"))));
        Assert.assertThat((Object)this.runtime().toString(result), (Matcher)Matchers.is((Object)"{\"\\\"Hello\\\"\\nwo\\r\\\\ld\\t\":\"\\n\\r\"}"));
    }

    @Test
    public void toStringWithAStringReturnsTheArgument() {
        T result = this.search("to_string('hello')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonString("hello")));
    }

    @Test(expected=ArityException.class)
    public void toStringRequiresExactlyOneArgument1() {
        this.search("to_string()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void toStringRequiresExactlyOneArgument2() {
        this.search("to_string(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void toStringRequiresAValue() {
        this.search("to_string(&foo)", this.parse("{}"));
    }

    @Test
    public void toNumberWithANumberReturnsTheArgument() {
        T result = this.search("to_number(`3`)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(3)));
    }

    @Test
    public void toNumberParsesAnIntegerStringToANumber() {
        T result = this.search("to_number('33')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(33)));
    }

    @Test
    public void toNumberParsesAnFloatStringToANumber() {
        T result = this.search("to_number('3.3')", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNumber(3.3)));
    }

    @Test
    public void toNumberReturnsNullWhenGivenNonNumberString() {
        T result = this.search("to_number('n=3.3')", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void toNumberReturnsNullWhenGivenAnArray() {
        T result = this.search("to_number(@)", this.parse("[]"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void toNumberReturnsNullWhenGivenAnObject() {
        T result = this.search("to_number(@)", this.parse("{}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void toNumberReturnsNullWhenGivenABoolean() {
        T result = this.search("to_number(@)", this.parse("true"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test
    public void toNumberReturnsNullWhenGivenNull() {
        T result = this.search("to_number(@)", this.parse("null"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonNull()));
    }

    @Test(expected=ArityException.class)
    public void toNumberRequiresExactlyOneArgument1() {
        this.search("to_number()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void toNumberRequiresExactlyOneArgument2() {
        this.search("to_number(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void toNumberRequiresAValue() {
        this.search("to_number(&foo)", this.parse("{}"));
    }

    @Test
    public void typeReturnsTheTypeOfTheArgument() {
        Assert.assertThat(this.search("type(@)", this.parse("null")), (Matcher)Matchers.is(this.jsonString("null")));
        Assert.assertThat(this.search("type(@)", this.parse("false")), (Matcher)Matchers.is(this.jsonString("boolean")));
        Assert.assertThat(this.search("type(@)", this.parse("{\"foo\":3}")), (Matcher)Matchers.is(this.jsonString("object")));
        Assert.assertThat(this.search("type(@)", this.parse("[3, 4]")), (Matcher)Matchers.is(this.jsonString("array")));
        Assert.assertThat(this.search("type(@)", this.parse("\"foo\"")), (Matcher)Matchers.is(this.jsonString("string")));
        Assert.assertThat(this.search("type(@)", this.parse("1")), (Matcher)Matchers.is(this.jsonString("number")));
    }

    @Test(expected=ArityException.class)
    public void typeRequiresExactlyOneArgument1() {
        this.search("type()", this.parse("{}"));
    }

    @Test(expected=ArityException.class)
    public void typeRequiresExactlyOneArgument2() {
        this.search("type(`1`, `2`)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void typeRequiresAValue() {
        this.search("type(&foo)", this.parse("{}"));
    }

    @Test
    public void valuesReturnsTheValuesOfAnObjectsProperties() {
        T result = this.search("values(@)", this.parse("{\"foo\":\"one\",\"bar\":\"two\"}"));
        Assert.assertThat(result, (Matcher)Matchers.is(this.jsonArrayOfStrings("one", "two")));
    }

    @Test
    public void valuesReturnsAnEmptyArrayWhenGivenAnEmptyObject() {
        T result = this.search("values(@)", this.parse("{}"));
        Assert.assertThat((Object)this.runtime().toList(result), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test(expected=ArgumentTypeException.class)
    public void valuesRequiresAnObjectAsArgument() {
        this.search("values(@)", this.parse("[3]"));
    }

    @Test(expected=ArityException.class)
    public void valuesRequiresASingleArgument() {
        this.search("values(@, @)", this.parse("{}"));
    }

    @Test(expected=ArgumentTypeException.class)
    public void valuesRequiresAValue() {
        this.search("values(&foo)", this.parse("{}"));
    }

    @Test
    public void valuesFromTheInputAreEqualToValuesFromLiterals() {
        T input = this.parse("{\"a\":1,\"b\":2.0,\"c\":\"foo\"}");
        Assert.assertThat(this.search("a == `1`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("b == `2.0`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("c == `\"foo\"`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("c == 'foo'", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void calculatedValuesAreEqualToValuesFromLiterals() {
        T input = this.parse("{\"a\":[1],\"b\":-2.0,\"c\":[\"fo\",\"o\"]}");
        Assert.assertThat(this.search("length(a) == `1`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("[length(a)] == `[1]`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("{size: length(a)} == `{\"size\": 1}`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("abs(b) == `2.0`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("join('', c) == `\"foo\"`", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
        Assert.assertThat(this.search("join('', c) == 'foo'", input), (Matcher)Matchers.is(this.jsonBoolean(true)));
    }

    @Test
    public void toListReturnsAListWhenGivenAnArray() {
        List list = this.runtime().toList(this.parse("[1, 2, 3]"));
        Assert.assertThat((Object)list, (Matcher)Matchers.is(Arrays.asList(this.parse("1"), this.parse("2"), this.parse("3"))));
    }

    @Test
    public void toListReturnsTheValuesOfAnObjectInOrder() {
        List list = this.runtime().toList(this.parse("{\"one\":1,\"two\":2,\"three\":3}"));
        Assert.assertThat((Object)list, (Matcher)Matchers.is(Arrays.asList(this.parse("1"), this.parse("2"), this.parse("3"))));
    }

    @Test
    public void toListReturnsAnEmptyListWhenGivenSomethingThatIsNotArrayOrObject() {
        List list = this.runtime().toList(this.parse("3"));
        Assert.assertThat((Object)list, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void toNumberReturnsANullValueWhenGivenANonNumber() {
        Number n = this.runtime().toNumber(this.parse("[]"));
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void getPropertyNamesReturnsAnEmptyListWhenGivenANonObject() {
        Collection properties = this.runtime().getPropertyNames(this.parse("[]"));
        Assert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test(expected=Exception.class)
    public void parseStringThrowsImplementationSpecificExceptionWhenGivenBadJson() {
        this.parse("{");
    }

    @Test
    public void compareReturnsMinusOneWhenTwoArraysAreNotEqual() {
        int result1 = this.runtime().compare(this.parse("[1]"), this.parse("[1,2]"));
        int result2 = this.runtime().compare(this.parse("[1,3]"), this.parse("[1,2]"));
        Assert.assertThat((Object)result1, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)result2, (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void compareReturnsMinusOneWhenTwoObjectsAreNotEqual() {
        int result1 = this.runtime().compare(this.parse("{\"one\":1}"), this.parse("{\"one\":1,\"two\":2}"));
        int result2 = this.runtime().compare(this.parse("{\"one\":1,\"two\":2,\"three\":3}"), this.parse("{\"one\":1,\"two\":2}"));
        Assert.assertThat((Object)result1, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)result2, (Matcher)Matchers.is((Object)-1));
    }
}

