/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.ComplianceRunner;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=ComplianceRunner.class)
public abstract class JmesPathComplianceTest<T> {
    private static final String TESTS_PATH = "/jmespath.test/tests/";

    protected abstract Adapter<T> runtime();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T loadFeatureDescription(String featureName) {
        String path = String.format("%s%s.json", TESTS_PATH, featureName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JmesPathComplianceTest.class.getResourceAsStream(path), Charset.forName("UTF-8")));){
            String line;
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            Object object = this.runtime().parseString(buffer.toString());
            return (T)object;
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Failed parsing %s", path), ioe);
        }
    }

    public Iterable<String> getFeatureNames() {
        try {
            LinkedList<String> featureNames = new LinkedList<String>();
            URI uri = JmesPathComplianceTest.class.getResource(TESTS_PATH).toURI();
            if (uri.getScheme().equals("jar")) {
                String jarPath = uri.toString().substring("jar:file:".length(), uri.toString().indexOf("!"));
                try (JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String fileName = entries.nextElement().getName();
                        if (!fileName.startsWith(TESTS_PATH)) continue;
                        featureNames.add(fileName.substring(0, fileName.length() - 5));
                    }
                }
            } else {
                File[] testFiles = new File(uri).listFiles();
                if (testFiles != null) {
                    for (File testFile : testFiles) {
                        String fileName = testFile.getName();
                        featureNames.add(fileName.substring(0, fileName.length() - 5));
                    }
                }
            }
            return featureNames;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not load compliance feature names", ioe);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Could not load compliance feature names", use);
        }
    }

    public Collection<ComplianceTest<T>> getTests(String featureName) {
        LinkedList<ComplianceTest<T>> tests = new LinkedList<ComplianceTest<T>>();
        T featureDescription = this.loadFeatureDescription(featureName);
        for (Object suiteDescription : this.runtime().toList(featureDescription)) {
            String suiteComment = this.valueAsStringOrNull(suiteDescription, "comment");
            Object input = this.runtime().getProperty(suiteDescription, "given");
            Object caseDescriptions = this.runtime().getProperty(suiteDescription, "cases");
            for (Object caseDescription : this.runtime().toList(caseDescriptions)) {
                String testComment = this.valueAsStringOrNull(caseDescription, "comment");
                if (testComment == null) {
                    testComment = this.valueAsStringOrNull(caseDescription, "description");
                }
                String expression = this.valueAsStringOrNull(caseDescription, "expression");
                Object expectedResult = this.runtime().getProperty(caseDescription, "result");
                String expectedError = this.valueAsStringOrNull(caseDescription, "error");
                String benchmark = this.valueAsStringOrNull(caseDescription, "benchmark");
                if (this.runtime().typeOf(expectedResult) == JmesPathType.NULL && expectedError == null) continue;
                tests.add(new ComplianceTest<Object>(this.runtime(), featureName, expression, input, expectedResult, expectedError, suiteComment, testComment, benchmark));
            }
        }
        return tests;
    }

    private String valueAsStringOrNull(T object, String key) {
        Object value = this.runtime().getProperty(object, key);
        return this.runtime().typeOf(value) == JmesPathType.NULL ? null : this.runtime().toString(value);
    }

    public Collection<ComplianceTest<T>> getAllTests() {
        LinkedList<ComplianceTest<T>> tests = new LinkedList<ComplianceTest<T>>();
        for (String featureName : this.getFeatureNames()) {
            tests.addAll(this.getTests(featureName));
        }
        return tests;
    }

    public static class ComplianceTest<U> {
        private final Adapter<U> runtime;
        private final String featureName;
        private final String expression;
        private final U input;
        private final U expectedResult;
        private final String expectedError;
        private final String suiteComment;
        private final String testComment;

        public ComplianceTest(Adapter<U> runtime, String featureName, String expression, U input, U expectedResult, String expectedError, String suiteComment, String testComment, String benchmark) {
            this.runtime = runtime;
            this.featureName = featureName;
            this.expression = expression;
            this.input = input;
            this.expectedResult = expectedResult;
            this.expectedError = expectedError;
            this.suiteComment = suiteComment;
            this.testComment = testComment;
        }

        public String name() {
            StringBuilder name = new StringBuilder();
            name.append(this.featureName);
            name.append(": ");
            if (this.suiteComment != null) {
                name.append(this.suiteComment);
                name.append(" ");
            }
            if (this.testComment != null) {
                name.append(this.testComment);
            } else {
                name.append(this.expression);
            }
            return name.toString();
        }

        public void run() {
            try {
                Expression compiledExpression = this.runtime.compile(this.expression);
                Object result = compiledExpression.search(this.input);
                if (this.expectedError == null) {
                    Assert.assertTrue((String)String.format("Expected <%s> to be <%s>, expression <%s> compiled expression <%s>", result, this.expectedResult, this.expression, compiledExpression), (this.runtime.compare(this.expectedResult, result) == 0 ? 1 : 0) != 0);
                } else {
                    Assert.fail((String)String.format("Expected \"%s\" error", this.expectedError));
                }
            }
            catch (Exception e) {
                if (this.expectedError == null) {
                    throw e;
                }
                String[] pieces = this.expectedError.split("-");
                Matcher matcher = Matchers.containsString((String)pieces[0]);
                for (int i = 1; i < pieces.length; ++i) {
                    matcher = Matchers.allOf((Matcher)matcher, (Matcher)Matchers.containsString((String)pieces[i]));
                }
                Assert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)matcher);
            }
        }
    }
}

