/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath;

import io.burt.jmespath.JmesPathComplianceTest;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class ComplianceRunner<T>
extends Runner {
    private final Class<JmesPathComplianceTest<T>> testClass;

    public ComplianceRunner(Class<JmesPathComplianceTest<T>> testClass) {
        this.testClass = testClass;
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.testClass.getName(), (Annotation[])this.testClass.getAnnotations());
        for (JmesPathComplianceTest.ComplianceTest<T> complianceTest : this.getAllTests()) {
            description.addChild(this.createDescription(complianceTest));
        }
        return description;
    }

    private Description createDescription(JmesPathComplianceTest.ComplianceTest<T> complianceTest) {
        return Description.createTestDescription(this.testClass, (String)complianceTest.name());
    }

    private Collection<JmesPathComplianceTest.ComplianceTest<T>> getAllTests() {
        try {
            return this.testClass.newInstance().getAllTests();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Could not instantiate runtime", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not instantiate runtime", iae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        for (JmesPathComplianceTest.ComplianceTest<T> complianceTest : this.getAllTests()) {
            Description testDescription = this.createDescription(complianceTest);
            notifier.fireTestStarted(testDescription);
            try {
                complianceTest.run();
            }
            catch (AssertionError ae) {
                notifier.fireTestFailure(new Failure(testDescription, (Throwable)((Object)ae)));
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(testDescription, (Throwable)e));
            }
            finally {
                notifier.fireTestFinished(testDescription);
            }
        }
    }
}

