/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.utils;

import io.jafar.utils.CustomByteBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SplicedMappedByteBuffer
implements CustomByteBuffer {
    private final int spliceSize;
    private int index = 0;
    private int offset = 0;
    private long position = 0L;
    private long mark = 0L;
    private final long limit;
    private final long sliceBase;
    private final boolean nativeOrder;
    private final MappedByteBuffer[] splices;
    private final byte[] numArray = new byte[8];

    SplicedMappedByteBuffer(MappedByteBuffer[] splices, int spliceSize, int sliceOffset, int sliceIndex, long limit, boolean nativeOrder) {
        this.splices = splices;
        this.index = sliceIndex;
        this.offset = sliceOffset;
        this.spliceSize = spliceSize;
        this.limit = limit;
        this.sliceBase = (long)this.index * (long)spliceSize + (long)this.offset;
        this.nativeOrder = nativeOrder;
    }

    SplicedMappedByteBuffer(Path file, int spliceSize) throws IOException {
        this.sliceBase = 0L;
        this.spliceSize = spliceSize;
        this.limit = Files.size(file);
        int count = (int)(((long)spliceSize + this.limit - 1L) / (long)spliceSize);
        this.splices = new MappedByteBuffer[count];
        boolean inOrder = true;
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");
             FileChannel channel = raf.getChannel();){
            long remaining = this.limit;
            for (int i = 0; i < count; ++i) {
                this.splices[i] = channel.map(FileChannel.MapMode.READ_ONLY, (long)i * (long)spliceSize, Math.min((long)spliceSize, remaining));
                inOrder &= this.splices[i].order() == ByteOrder.nativeOrder();
                this.splices[i].order(ByteOrder.nativeOrder());
                remaining -= (long)spliceSize;
            }
            this.nativeOrder = inOrder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isNativeOrder() {
        return this.nativeOrder;
    }

    @Override
    public CustomByteBuffer slice() {
        return new SplicedMappedByteBuffer(this.splices, this.spliceSize, this.offset, this.index, this.remaining(), this.nativeOrder);
    }

    @Override
    public CustomByteBuffer slice(long pos, long len) {
        if (pos + len > this.limit) {
            throw new BufferOverflowException();
        }
        int realIndex = (int)((this.sliceBase + pos) / (long)this.spliceSize);
        int realOffset = (int)((this.sliceBase + pos) % (long)this.spliceSize);
        return new SplicedMappedByteBuffer(this.splices, this.spliceSize, realOffset, realIndex, len, this.nativeOrder);
    }

    @Override
    public CustomByteBuffer order(ByteOrder order) {
        for (int i = 0; i < this.splices.length; ++i) {
            this.splices[i] = (MappedByteBuffer)this.splices[i].order(order);
        }
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.splices[0].order();
    }

    @Override
    public void position(long position) {
        if (position > this.limit) {
            throw new BufferOverflowException();
        }
        this.index = (int)((position + this.sliceBase) / (long)this.spliceSize);
        this.offset = (int)((position + this.sliceBase) % (long)this.spliceSize);
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    private void checkSpliceOffset() {
        if (this.offset == this.spliceSize) {
            if (++this.index == this.splices.length) {
                throw new BufferOverflowException();
            }
            this.offset = 0;
            this.splices[this.index].position(this.offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(byte[] buffer, int offset, int length) {
        int toLoad;
        int loaded = 0;
        do {
            this.checkSpliceOffset();
            toLoad = Math.min(this.spliceSize - this.offset, length - loaded);
            int oldPos = this.splices[this.index].position();
            try {
                this.splices[this.index].position(this.offset);
                this.splices[this.index].get(buffer, offset + loaded, toLoad);
            }
            finally {
                this.splices[this.index].position(oldPos);
            }
            this.offset += toLoad;
        } while ((loaded += toLoad) < length);
        this.position += (long)length;
    }

    @Override
    public byte get() {
        this.checkSpliceOffset();
        ++this.position;
        return this.splices[this.index].get(this.offset++);
    }

    @Override
    public short getShort() {
        this.checkSpliceOffset();
        if (this.spliceSize - this.offset >= 2) {
            this.position += 2L;
            short ret = this.splices[this.index].getShort(this.offset);
            this.offset += 2;
            return ret;
        }
        this.numArray[0] = this.get();
        this.numArray[1] = this.get();
        return ByteBuffer.wrap(this.numArray).order(this.splices[0].order()).getShort();
    }

    @Override
    public int getInt() {
        this.checkSpliceOffset();
        if (this.spliceSize - this.offset >= 4) {
            this.position += 4L;
            int ret = this.splices[this.index].getInt(this.offset);
            this.offset += 4;
            return ret;
        }
        int splitPoint = this.spliceSize - this.offset;
        this.get(this.numArray, 0, splitPoint);
        this.get(this.numArray, splitPoint, 4 - splitPoint);
        return ByteBuffer.wrap(this.numArray).order(this.splices[0].order()).getInt();
    }

    @Override
    public float getFloat() {
        this.checkSpliceOffset();
        if (this.spliceSize - this.offset >= 4) {
            this.position += 4L;
            float ret = this.splices[this.index].getFloat(this.offset);
            this.offset += 4;
            return ret;
        }
        int splitPoint = this.spliceSize - this.offset;
        this.get(this.numArray, 0, splitPoint);
        this.get(this.numArray, splitPoint, 4 - splitPoint);
        return ByteBuffer.wrap(this.numArray).order(this.splices[0].order()).getFloat();
    }

    @Override
    public double getDouble() {
        this.checkSpliceOffset();
        if (this.spliceSize - this.offset >= 8) {
            this.position += 8L;
            double ret = this.splices[this.index].getDouble(this.offset);
            this.offset += 8;
            return ret;
        }
        int splitPoint = this.spliceSize - this.offset;
        this.get(this.numArray, 0, splitPoint);
        this.get(this.numArray, splitPoint, 8 - splitPoint);
        return ByteBuffer.wrap(this.numArray).order(this.splices[0].order()).getDouble();
    }

    @Override
    public long getLong() {
        this.checkSpliceOffset();
        if (this.spliceSize - this.offset >= 8) {
            this.position += 8L;
            long ret = this.splices[this.index].getLong(this.offset);
            this.offset += 8;
            return ret;
        }
        int splitPoint = this.spliceSize - this.offset;
        this.get(this.numArray, 0, splitPoint);
        this.get(this.numArray, splitPoint, 8 - splitPoint);
        return ByteBuffer.wrap(this.numArray).order(this.splices[0].order()).getLong();
    }

    @Override
    public void mark() {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
        this.index = (int)((this.position + this.sliceBase) / (long)this.spliceSize);
        this.offset = (int)((this.position + this.sliceBase) % (long)this.spliceSize);
    }
}

