/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.api.Internal;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.api.UntypedStrategy;
import io.jafar.parser.impl.LazyEventMap;
import io.jafar.parser.impl.LazyMapValueBuilder;
import io.jafar.parser.internal_api.ClassDefiners;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.UntypedEventDeserializer;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class UntypedCodeGenerator
implements Opcodes {
    private static final boolean LOGS_ENABLED = false;
    private static final Logger log = LoggerFactory.getLogger(UntypedCodeGenerator.class);
    private static final AtomicLong CLASS_COUNTER = new AtomicLong(0L);
    private static final int SIMPLE_EVENT_FIELD_THRESHOLD = 10;
    private static final int SIMPLE_EVENT_NESTED_THRESHOLD = 2;

    private UntypedCodeGenerator() {
    }

    public static UntypedEventDeserializer generate(MetadataClass eventType) {
        return UntypedCodeGenerator.generate(eventType, UntypedStrategy.SPARSE_ACCESS);
    }

    public static UntypedEventDeserializer generate(MetadataClass eventType, UntypedStrategy strategy) {
        try {
            String className = UntypedCodeGenerator.generateClassName(eventType);
            ClassWriter cw = new ClassWriter(3);
            cw.visit(55, 17, className.replace('.', '/'), null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(UntypedEventDeserializer.class)});
            boolean useEager = UntypedCodeGenerator.shouldUseEagerDeserialization(eventType, strategy);
            if (useEager) {
                UntypedCodeGenerator.generateEagerDeserializer(cw, className, eventType);
            } else {
                UntypedCodeGenerator.generateLazyDeserializer(cw, className, eventType);
            }
            cw.visitEnd();
            byte[] bytecode = cw.toByteArray();
            Class<?> generatedClass = ClassDefiners.best().define(bytecode, UntypedEventDeserializer.class);
            return (UntypedEventDeserializer)generatedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            log.error("Failed to generate deserializer for {}", (Object)eventType.getName(), (Object)e);
            throw new RuntimeException("Code generation failed for " + eventType.getName(), e);
        }
    }

    private static boolean shouldUseEagerDeserialization(MetadataClass type, UntypedStrategy strategy) {
        UntypedStrategy effectiveStrategy = strategy != null ? strategy : UntypedStrategy.SPARSE_ACCESS;
        switch (effectiveStrategy) {
            case FULL_ITERATION: {
                return true;
            }
            case SPARSE_ACCESS: {
                return UntypedCodeGenerator.isSimpleEvent(type);
            }
            case AUTO: {
                return UntypedCodeGenerator.isSimpleEvent(type);
            }
        }
        return UntypedCodeGenerator.isSimpleEvent(type);
    }

    private static String generateClassName(MetadataClass eventType) {
        String sanitized = eventType.getName().replace('.', '_').replace('$', '_').replaceAll("[^a-zA-Z0-9_]", "_");
        return "io.jafar.parser.internal_api.UntypedDeserializer_" + sanitized + "_" + CLASS_COUNTER.incrementAndGet();
    }

    private static boolean isSimpleEvent(MetadataClass type) {
        int fieldCount = type.getFields().size();
        if (fieldCount > 10) {
            return false;
        }
        int nestedObjectCount = 0;
        for (MetadataField field : type.getFields()) {
            MetadataClass fieldType = field.getType();
            if (fieldType.isSimpleType() || fieldType.isPrimitive() || field.getDimension() != 0 || field.hasConstantPool() || ++nestedObjectCount <= 2) continue;
            return false;
        }
        return true;
    }

    private static void generateEagerDeserializer(ClassWriter cw, String className, MetadataClass type) {
        MethodVisitor ctor = cw.visitMethod(1, "<init>", "()V", null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        ctor.visitInsn(177);
        ctor.visitMaxs(0, 0);
        ctor.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "deserialize", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{Type.getType(RecordingStream.class), Type.getType(ParserContext.class)}), "(Lio/jafar/parser/internal_api/RecordingStream;Lio/jafar/parser/api/ParserContext;)Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        UntypedCodeGenerator.addLog(mv, "Eager deserialize: " + type.getName());
        int fieldCount = type.getFields().size();
        mv.visitTypeInsn(187, Type.getInternalName(HashMap.class));
        mv.visitInsn(89);
        UntypedCodeGenerator.pushInt(mv, fieldCount);
        mv.visitMethodInsn(183, Type.getInternalName(HashMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        mv.visitVarInsn(58, 3);
        HashSet<MetadataClass> nestedTypes = new HashSet<MetadataClass>();
        for (MetadataField field : type.getFields()) {
            mv.visitVarInsn(25, 3);
            mv.visitLdcInsn((Object)field.getName());
            UntypedCodeGenerator.generateFieldRead(mv, field, 1, 2, className, nestedTypes);
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 3);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (MetadataClass nestedType : nestedTypes) {
            UntypedCodeGenerator.generateNestedObjectHelper(cw, className, nestedType);
        }
    }

    private static void generateLazyDeserializer(ClassWriter cw, String className, MetadataClass type) {
        cw.visitField(26, "ARRAY_POOL_TL", Type.getDescriptor(ThreadLocal.class), "Ljava/lang/ThreadLocal<Lio/jafar/parser/impl/LazyMapValueBuilder$ArrayPool;>;", null).visitEnd();
        MethodVisitor clinit = cw.visitMethod(8, "<clinit>", "()V", null, null);
        clinit.visitCode();
        clinit.visitInvokeDynamicInsn("get", "()Ljava/util/function/Supplier;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getMethodType((String)"()Ljava/lang/Object;"), new Handle(8, Type.getInternalName(LazyMapValueBuilder.ArrayPool.class), "<init>", "()V", false), Type.getMethodType((String)"()Lio/jafar/parser/impl/LazyMapValueBuilder$ArrayPool;")});
        clinit.visitMethodInsn(184, Type.getInternalName(ThreadLocal.class), "withInitial", Type.getMethodDescriptor((Type)Type.getType(ThreadLocal.class), (Type[])new Type[]{Type.getType(Supplier.class)}), false);
        clinit.visitFieldInsn(179, className.replace('.', '/'), "ARRAY_POOL_TL", Type.getDescriptor(ThreadLocal.class));
        clinit.visitInsn(177);
        clinit.visitMaxs(0, 0);
        clinit.visitEnd();
        MethodVisitor ctor = cw.visitMethod(1, "<init>", "()V", null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        ctor.visitInsn(177);
        ctor.visitMaxs(0, 0);
        ctor.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "deserialize", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{Type.getType(RecordingStream.class), Type.getType(ParserContext.class)}), "(Lio/jafar/parser/internal_api/RecordingStream;Lio/jafar/parser/api/ParserContext;)Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        UntypedCodeGenerator.addLog(mv, "Lazy deserialize: " + type.getName());
        mv.visitFieldInsn(178, className.replace('.', '/'), "ARRAY_POOL_TL", Type.getDescriptor(ThreadLocal.class));
        mv.visitMethodInsn(182, Type.getInternalName(ThreadLocal.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), false);
        mv.visitTypeInsn(192, Type.getInternalName(LazyMapValueBuilder.ArrayPool.class));
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, Type.getInternalName(LazyMapValueBuilder.ArrayPool.class), "reset", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        HashSet<MetadataClass> nestedTypes = new HashSet<MetadataClass>();
        for (MetadataField field : type.getFields()) {
            mv.visitVarInsn(25, 3);
            mv.visitLdcInsn((Object)field.getName());
            UntypedCodeGenerator.generateFieldRead(mv, field, 1, 2, className, nestedTypes);
            mv.visitMethodInsn(182, Type.getInternalName(LazyMapValueBuilder.ArrayPool.class), "add", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)}), false);
        }
        mv.visitTypeInsn(187, Type.getInternalName(LazyEventMap.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(LazyMapValueBuilder.ArrayPool.class), "size", "I");
        mv.visitMethodInsn(183, Type.getInternalName(LazyEventMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(LazyMapValueBuilder.ArrayPool.class), Type.INT_TYPE}), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (MetadataClass nestedType : nestedTypes) {
            UntypedCodeGenerator.generateNestedObjectHelper(cw, className, nestedType);
        }
    }

    private static void generateFieldRead(MethodVisitor mv, MetadataField field, int streamVar, int contextVar, String className, Set<MetadataClass> nestedTypes) {
        MetadataClass fieldType = field.getType();
        if (field.getDimension() == 1) {
            UntypedCodeGenerator.generateArrayRead(mv, field, streamVar, contextVar, className, nestedTypes);
            return;
        }
        if (field.hasConstantPool()) {
            mv.visitVarInsn(25, streamVar);
            mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
            mv.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.LONG_TYPE}), false);
            return;
        }
        if (!fieldType.isSimpleType() && !fieldType.isPrimitive()) {
            nestedTypes.add(fieldType);
            UntypedCodeGenerator.generateNestedObjectInline(mv, fieldType, streamVar, contextVar, className);
            return;
        }
        mv.visitVarInsn(25, streamVar);
        String readMethod = UntypedCodeGenerator.getReadMethod(fieldType);
        Type returnType = UntypedCodeGenerator.getReadReturnType(fieldType);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), readMethod, Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]), false);
        if (returnType.getSort() != 10 && returnType.getSort() != 9) {
            Class<?> wrapperClass = UntypedCodeGenerator.getWrapperClass(fieldType);
            Type primitiveType = returnType;
            mv.visitMethodInsn(184, Type.getInternalName(wrapperClass), "valueOf", Type.getMethodDescriptor((Type)Type.getType(wrapperClass), (Type[])new Type[]{primitiveType}), false);
        }
    }

    private static void generateNestedObjectInline(MethodVisitor mv, MetadataClass nestedType, int streamVar, int contextVar, String className) {
        String helperName = "deserialize_" + UntypedCodeGenerator.sanitizeName(nestedType.getName());
        mv.visitVarInsn(25, streamVar);
        mv.visitVarInsn(25, contextVar);
        mv.visitMethodInsn(184, className.replace('.', '/'), helperName, Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{Type.getType(RecordingStream.class), Type.getType(ParserContext.class)}), false);
    }

    private static void generateNestedObjectHelper(ClassWriter cw, String className, MetadataClass nestedType) {
        String helperName = "deserialize_" + UntypedCodeGenerator.sanitizeName(nestedType.getName());
        MethodVisitor mv = cw.visitMethod(10, helperName, Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{Type.getType(RecordingStream.class), Type.getType(ParserContext.class)}), "(Lio/jafar/parser/internal_api/RecordingStream;Lio/jafar/parser/api/ParserContext;)Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        UntypedCodeGenerator.addLog(mv, "Nested deserialize: " + nestedType.getName());
        int fieldCount = nestedType.getFields().size();
        mv.visitTypeInsn(187, Type.getInternalName(HashMap.class));
        mv.visitInsn(89);
        UntypedCodeGenerator.pushInt(mv, fieldCount);
        mv.visitMethodInsn(183, Type.getInternalName(HashMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        mv.visitVarInsn(58, 2);
        HashSet<MetadataClass> innerNestedTypes = new HashSet<MetadataClass>();
        for (MetadataField field : nestedType.getFields()) {
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn((Object)field.getName());
            UntypedCodeGenerator.generateFieldRead(mv, field, 0, 1, className, innerNestedTypes);
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (MetadataClass innerNestedType : innerNestedTypes) {
            if (innerNestedType.equals(nestedType)) continue;
            UntypedCodeGenerator.generateNestedObjectHelper(cw, className, innerNestedType);
        }
    }

    private static void generateArrayRead(MethodVisitor mv, MetadataField field, int streamVar, int contextVar, String className, Set<MetadataClass> nestedTypes) {
        mv.visitVarInsn(25, streamVar);
        mv.visitMethodInsn(182, Type.getInternalName(RecordingStream.class), "readVarint", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(136);
        int lenVar = streamVar + contextVar + 10;
        mv.visitVarInsn(54, lenVar);
        mv.visitVarInsn(21, lenVar);
        mv.visitTypeInsn(189, Type.getInternalName(Object.class));
        int arrayVar = lenVar + 1;
        mv.visitVarInsn(58, arrayVar);
        mv.visitInsn(3);
        int iVar = arrayVar + 1;
        mv.visitVarInsn(54, iVar);
        Label loopStart = new Label();
        Label loopEnd = new Label();
        mv.visitLabel(loopStart);
        mv.visitVarInsn(21, iVar);
        mv.visitVarInsn(21, lenVar);
        mv.visitJumpInsn(162, loopEnd);
        mv.visitVarInsn(25, arrayVar);
        mv.visitVarInsn(21, iVar);
        UntypedCodeGenerator.generateFieldRead(mv, field, streamVar, contextVar, className, nestedTypes);
        mv.visitInsn(83);
        mv.visitIincInsn(iVar, 1);
        mv.visitJumpInsn(167, loopStart);
        mv.visitLabel(loopEnd);
        mv.visitVarInsn(25, arrayVar);
    }

    private static void pushInt(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn((Object)value);
        }
    }

    private static String getReadMethod(MetadataClass fieldType) {
        String typeName;
        switch (typeName = fieldType.getName()) {
            case "byte": {
                return "read";
            }
            case "boolean": {
                return "readBoolean";
            }
            case "short": {
                return "readShort";
            }
            case "char": {
                return "readShort";
            }
            case "int": {
                return "readVarint";
            }
            case "long": {
                return "readVarint";
            }
            case "float": {
                return "readFloat";
            }
            case "double": {
                return "readDouble";
            }
            case "java.lang.String": {
                return "readUTF8";
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + typeName);
    }

    private static Type getReadReturnType(MetadataClass fieldType) {
        String typeName;
        switch (typeName = fieldType.getName()) {
            case "byte": {
                return Type.BYTE_TYPE;
            }
            case "boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "short": 
            case "char": {
                return Type.SHORT_TYPE;
            }
            case "int": 
            case "long": {
                return Type.LONG_TYPE;
            }
            case "float": {
                return Type.FLOAT_TYPE;
            }
            case "double": {
                return Type.DOUBLE_TYPE;
            }
            case "java.lang.String": {
                return Type.getType(String.class);
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + typeName);
    }

    private static Class<?> getWrapperClass(MetadataClass fieldType) {
        String typeName;
        switch (typeName = fieldType.getName()) {
            case "byte": {
                return Byte.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "short": {
                return Short.class;
            }
            case "char": {
                return Character.class;
            }
            case "int": 
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    private static String sanitizeName(String name) {
        return name.replace('.', '_').replace('$', '_').replaceAll("[^a-zA-Z0-9_]", "_");
    }

    private static void addLog(MethodVisitor mv, String msg) {
    }
}

