/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContext;
import io.jafar.parser.impl.TypedParserContextFactory;
import io.jafar.parser.internal_api.CheckpointEvent;
import io.jafar.parser.internal_api.ChunkHeader;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.ParserContextFactory;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamingChunkParser
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingChunkParser.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() - 2, 1), r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private boolean closed = false;
    private final ParserContextFactory contextFactory;

    public StreamingChunkParser(ParserContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void parse(Path path, ChunkParserListener listener) throws IOException {
        if (this.closed) {
            throw new IOException("Parser is closed");
        }
        try (RecordingStream stream = new RecordingStream(path, this.contextFactory.newContext());){
            this.parse(stream, listener);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            this.executor.shutdown();
        }
    }

    private Future<Boolean> submitParsingTask(ChunkHeader chunkHeader, RecordingStream chunkStream, ChunkParserListener listener, long remainder) {
        return this.executor.submit(() -> {
            int chunkCounter = chunkHeader.order;
            ParserContext chunkContext = chunkStream.getContext();
            try {
                if (!listener.onChunkStart(chunkContext, chunkCounter, chunkHeader)) {
                    log.debug("'onChunkStart' returned false. Skipping metadata and events for chunk {}", (Object)chunkCounter);
                    listener.onChunkEnd(chunkContext, chunkCounter, true);
                    return true;
                }
                if (!this.readMetadata(chunkStream, chunkHeader, listener, false)) {
                    log.debug("'onMetadata' returned false. Skipping events for chunk {}", (Object)chunkCounter);
                    listener.onChunkEnd(chunkContext, chunkCounter, true);
                    return false;
                }
                if (!this.readConstantPool(chunkStream, chunkHeader, listener)) {
                    log.debug("'onCheckpoint' returned false. Skipping the rest of the chunk {}", (Object)chunkCounter);
                    listener.onChunkEnd(chunkContext, chunkCounter, true);
                    return false;
                }
                chunkStream.position(remainder);
                while (chunkStream.position() < (long)chunkHeader.size) {
                    long currentPos;
                    long eventStartPos = chunkStream.position();
                    chunkStream.mark();
                    int eventSize = (int)chunkStream.readVarint();
                    if (eventSize <= 0) continue;
                    long eventType = chunkStream.readVarint();
                    if (eventType > 1L && !listener.onEvent(chunkContext, eventType, eventStartPos, eventSize, (long)eventSize - ((currentPos = chunkStream.position()) - eventStartPos))) {
                        log.debug("'onEvent({}, stream, {})' returned false. Skipping the rest of the chunk {}", new Object[]{eventType, (long)eventSize - (currentPos - eventStartPos), chunkCounter});
                        listener.onChunkEnd(chunkContext, chunkCounter, true);
                        return false;
                    }
                    chunkStream.position(eventStartPos + (long)eventSize);
                }
                return listener.onChunkEnd(chunkContext, chunkCounter, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void parse(RecordingStream stream, ChunkParserListener listener) throws IOException {
        if (stream.available() == 0L) {
            return;
        }
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        try {
            listener.onRecordingStart(stream.getContext());
            int chunkCounter = 1;
            while (stream.available() > 0L) {
                ChunkHeader header = new ChunkHeader(stream, chunkCounter);
                long remainder = stream.position() - header.offset;
                RecordingStream chunkStream = stream.slice(header.offset, header.size, this.contextFactory.newContext(stream.getContext(), chunkCounter));
                stream.position(header.offset + (long)header.size);
                results.add(this.submitParsingTask(header, chunkStream, listener, remainder));
                ++chunkCounter;
            }
            results.forEach(f -> {
                try {
                    f.get();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to process chunk", t);
                }
            });
        }
        catch (EOFException e) {
            results.forEach(f -> f.cancel(true));
            throw new IOException("Invalid buffer encountered during parsing", e);
        }
        catch (Throwable t) {
            results.forEach(f -> f.cancel(true));
            throw new IOException("Error occurred while parsing JFR recording", t);
        }
        finally {
            listener.onRecordingEnd(stream.getContext());
        }
    }

    private boolean readMetadata(RecordingStream stream, ChunkHeader header, ChunkParserListener listener, boolean forceConstantPools) throws IOException {
        TypedParserContext typedCtx;
        TypedParserContextFactory factory;
        stream.mark();
        stream.position(header.metaOffset);
        MetadataEvent m = new MetadataEvent(stream, forceConstantPools);
        ParserContext ctx = stream.getContext();
        if (ctx instanceof TypedParserContext && (factory = (typedCtx = (TypedParserContext)ctx).getFactory()) != null && typedCtx.getDeserializerCache() == null) {
            factory.resolveDeserializerCache(header.order, typedCtx.getMetadataLookup(), typedCtx);
        }
        if (!listener.onMetadata(ctx, m)) {
            return false;
        }
        ctx.onMetadataReady();
        stream.reset();
        return true;
    }

    private boolean readConstantPool(RecordingStream stream, ChunkHeader header, ChunkParserListener listener) throws IOException {
        return this.readConstantPool(stream, header.cpOffset, listener);
    }

    private boolean readConstantPool(RecordingStream stream, int position, ChunkParserListener listener) throws IOException {
        while (true) {
            stream.position(position);
            CheckpointEvent event = new CheckpointEvent(stream);
            event.readConstantPools();
            if (!listener.onCheckpoint(stream.getContext(), event)) {
                return false;
            }
            int delta = event.nextOffsetDelta;
            if (delta == 0) break;
            position += delta;
        }
        stream.getContext().onConstantPoolsReady();
        return true;
    }
}

