/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.utils.CustomByteBuffer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class RecordingStreamReader {
    protected RecordingStreamReader() {
    }

    public abstract RecordingStreamReader slice();

    public abstract RecordingStreamReader slice(long var1, long var3);

    public abstract long length();

    public abstract long remaining();

    public abstract long position();

    public abstract void position(long var1);

    public abstract void skip(long var1);

    public abstract byte read();

    public abstract void read(byte[] var1, int var2, int var3);

    public abstract boolean readBoolean();

    public abstract short readShort();

    public abstract int readInt();

    public abstract long readLong();

    public abstract float readFloat();

    public abstract double readDouble();

    public abstract long readVarint();

    public abstract void close() throws IOException;

    public static RecordingStreamReader mapped(Path path) throws IOException {
        return new MappedRecordingStreamReader(path);
    }

    public static final class MappedRecordingStreamReader
    extends RecordingStreamReader {
        private final CustomByteBuffer buffer;
        private final long length;
        private final boolean nativeOrder;
        private final int alignementOffset;
        private long remaining;

        public MappedRecordingStreamReader(Path path) throws IOException {
            this(CustomByteBuffer.map(path, Integer.MAX_VALUE), Files.size(path), 0);
        }

        private MappedRecordingStreamReader(CustomByteBuffer buffer, long length, int alignementOffset) {
            this.buffer = buffer;
            this.length = length;
            this.nativeOrder = buffer.isNativeOrder();
            this.alignementOffset = alignementOffset;
            this.remaining = length;
        }

        @Override
        public RecordingStreamReader slice() {
            long sliceLength = this.buffer.remaining();
            return new MappedRecordingStreamReader(this.buffer.slice(), sliceLength, (int)((long)this.alignementOffset + this.buffer.position()) % 8);
        }

        @Override
        public RecordingStreamReader slice(long pos, long size) {
            return new MappedRecordingStreamReader(this.buffer.slice(pos, size), size, (int)((long)this.alignementOffset + pos) % 8);
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long remaining() {
            return this.remaining;
        }

        @Override
        public long position() {
            return this.buffer.position();
        }

        @Override
        public void position(long newPosition) {
            this.remaining = this.length - newPosition;
            this.buffer.position(newPosition);
        }

        @Override
        public void skip(long n) {
            this.remaining -= n;
            this.buffer.position(this.buffer.position() + n);
        }

        @Override
        public byte read() {
            --this.remaining;
            return this.buffer.get();
        }

        @Override
        public void read(byte[] b, int off, int len) {
            this.remaining -= (long)len;
            this.buffer.get(b, off, len);
        }

        @Override
        public boolean readBoolean() {
            --this.remaining;
            return this.buffer.get() != 0;
        }

        @Override
        public short readShort() {
            this.remaining -= 2L;
            short s = this.buffer.getShort();
            return this.nativeOrder ? s : Short.reverseBytes(s);
        }

        @Override
        public int readInt() {
            this.remaining -= 4L;
            int i = this.buffer.getInt();
            return this.nativeOrder ? i : Integer.reverseBytes(i);
        }

        @Override
        public long readLong() {
            this.remaining -= 8L;
            long l = this.buffer.getLong();
            return this.nativeOrder ? l : Long.reverseBytes(l);
        }

        private static float reverseBytes(float f) {
            int i = Float.floatToRawIntBits(f);
            return Float.intBitsToFloat(Integer.reverseBytes(i));
        }

        private static double reverseBytes(double d) {
            long l = Double.doubleToRawLongBits(d);
            return Double.longBitsToDouble(Long.reverseBytes(l));
        }

        @Override
        public float readFloat() {
            this.remaining -= 4L;
            float f = this.buffer.getFloat();
            return this.nativeOrder ? f : MappedRecordingStreamReader.reverseBytes(f);
        }

        @Override
        public double readDouble() {
            this.remaining -= 8L;
            double d = this.buffer.getDouble();
            return this.nativeOrder ? d : MappedRecordingStreamReader.reverseBytes(d);
        }

        private static int findFirstUnset8thBit(long value) {
            long mask = -9187201950435737472L;
            long eighthBits = value & mask;
            long unsetBits = (eighthBits ^ 0xFFFFFFFFFFFFFFFFL) & mask;
            long collapsed = unsetBits * 0x101010101010101L;
            return Long.numberOfTrailingZeros(collapsed) / 8;
        }

        @Override
        public long readVarint() {
            return this.readVarintSeq();
        }

        private long readVarintSeq() {
            byte b0 = this.buffer.get();
            --this.remaining;
            long ret = (long)b0 & 0x7FL;
            if (b0 >= 0) {
                return ret;
            }
            byte b1 = this.buffer.get();
            --this.remaining;
            ret += ((long)b1 & 0x7FL) << 7;
            if (b1 >= 0) {
                return ret;
            }
            byte b2 = this.buffer.get();
            --this.remaining;
            ret += ((long)b2 & 0x7FL) << 14;
            if (b2 >= 0) {
                return ret;
            }
            byte b3 = this.buffer.get();
            --this.remaining;
            ret += ((long)b3 & 0x7FL) << 21;
            if (b3 >= 0) {
                return ret;
            }
            byte b4 = this.buffer.get();
            --this.remaining;
            ret += ((long)b4 & 0x7FL) << 28;
            if (b4 >= 0) {
                return ret;
            }
            byte b5 = this.buffer.get();
            --this.remaining;
            ret += ((long)b5 & 0x7FL) << 35;
            if (b5 >= 0) {
                return ret;
            }
            byte b6 = this.buffer.get();
            --this.remaining;
            ret += ((long)b6 & 0x7FL) << 42;
            if (b6 >= 0) {
                return ret;
            }
            byte b7 = this.buffer.get();
            --this.remaining;
            ret += ((long)b7 & 0x7FL) << 49;
            if (b7 >= 0) {
                return ret;
            }
            byte b8 = this.buffer.get();
            --this.remaining;
            return ret + ((long)(b8 & 0xFF) << 56);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

