/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.api.ConstantPool;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.MapValueBuilder;
import io.jafar.parser.internal_api.GenericValueReader;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import java.util.Iterator;

public final class MutableConstantPool
implements ConstantPool {
    private final Long2LongMap offsets;
    private final Long2ObjectMap<Object> entries;
    private final RecordingStream stream;
    private final MetadataClass clazz;

    public MutableConstantPool(RecordingStream chunkStream, long typeId, int count) {
        this.offsets = new Long2LongOpenHashMap(count);
        this.entries = new Long2ObjectOpenHashMap(count);
        this.stream = chunkStream;
        ParserContext context = chunkStream.getContext();
        this.clazz = context.getMetadataLookup().getClass(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long id) {
        long offset = this.offsets.get(id);
        if (offset > 0L) {
            Object o = this.entries.get(id);
            if (o == null) {
                long pos = this.stream.position();
                try {
                    this.stream.position(this.offsets.get(id));
                    Object typed = this.clazz.read(this.stream);
                    if (typed != null) {
                        o = typed;
                    } else {
                        GenericValueReader r = this.stream.getContext().get(GenericValueReader.class);
                        MapValueBuilder builder = (MapValueBuilder)r.getProcessor();
                        builder.onComplexValueStart(null, null, this.clazz);
                        try {
                            r.readValue(this.stream, this.clazz);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                        builder.onComplexValueEnd(null, null, this.clazz);
                        o = builder.getRoot();
                    }
                    this.entries.put(id, o);
                }
                finally {
                    this.stream.position(pos);
                }
            }
            return o;
        }
        return null;
    }

    @Override
    public int entryCount() {
        return this.offsets.size();
    }

    @Override
    public Iterator<Long> ids() {
        return new Iterator<Long>(){
            final LongIterator it;
            {
                this.it = MutableConstantPool.this.offsets.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Long next() {
                return this.it.nextLong();
            }
        };
    }

    @Override
    public boolean isIndexed() {
        return !this.offsets.isEmpty();
    }

    @Override
    public void ensureIndexed() {
    }

    public boolean containsKey(long key) {
        return this.offsets.containsKey(key);
    }

    public void addOffset(long id, long offset) {
        this.offsets.put(id, offset);
    }

    public long getOffset(long id) {
        return this.offsets.get(id);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public MetadataClass getType() {
        return this.clazz;
    }
}

