/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.utils.BytePacking;
import java.io.IOException;
import java.nio.ByteOrder;

public final class ChunkHeader {
    public static final int MAGIC_BE = BytePacking.pack(ByteOrder.BIG_ENDIAN, 'F', 'L', 'R', '\u0000');
    public final int order;
    public final long offset;
    public final short major;
    public final short minor;
    public final int size;
    public final int cpOffset;
    public final int metaOffset;
    public final long startNanos;
    public final long duration;
    public final long startTicks;
    public final long frequency;
    public final boolean compressed;

    ChunkHeader(RecordingStream recording, int index) throws IOException {
        this.order = index;
        this.offset = recording.position();
        int magic = recording.readInt();
        if (magic != MAGIC_BE) {
            throw new IOException("Invalid JFR Magic Number: " + Integer.toHexString(magic));
        }
        this.major = recording.readShort();
        this.minor = recording.readShort();
        this.size = (int)recording.readLong();
        this.cpOffset = (int)recording.readLong();
        this.metaOffset = (int)recording.readLong();
        this.startNanos = recording.readLong();
        this.duration = recording.readLong();
        this.startTicks = recording.readLong();
        this.frequency = recording.readLong();
        this.compressed = recording.readInt() != 0;
    }

    public String toString() {
        return "ChunkHeader{major=" + this.major + ", minor=" + this.minor + ", size=" + this.size + ", offset=" + this.offset + ", cpOffset=" + this.cpOffset + ", metaOffset=" + this.metaOffset + ", startNanos=" + this.startNanos + ", duration=" + this.duration + ", startTicks=" + this.startTicks + ", frequency=" + this.frequency + ", compressed=" + this.compressed + '}';
    }
}

