/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.TypeFilter;
import io.jafar.parser.api.Control;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.api.UntypedStrategy;
import io.jafar.parser.impl.ChunkInfoImpl;
import io.jafar.parser.impl.ControlImpl;
import io.jafar.parser.internal_api.CheckpointEvent;
import io.jafar.parser.internal_api.ChunkHeader;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.UntypedCodeGenerator;
import io.jafar.parser.internal_api.UntypedDeserializerCache;
import io.jafar.parser.internal_api.UntypedEventDeserializer;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import java.util.Map;

public abstract class EventStreamGenerated
implements ChunkParserListener {
    private final ChunkParserListener delegate;
    private final ThreadLocal<Control> control = ThreadLocal.withInitial(ControlImpl::new);

    public EventStreamGenerated(ChunkParserListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public final boolean onMetadata(ParserContext context, MetadataEvent metadata) {
        return this.delegate == null || this.delegate.onMetadata(context, metadata);
    }

    @Override
    public final boolean onChunkStart(ParserContext context, int chunkIndex, ChunkHeader header) {
        ((ControlImpl)this.control.get()).setStream(context.get(RecordingStream.class));
        context.put(Control.ChunkInfo.class, new ChunkInfoImpl(header));
        context.put(TypeFilter.class, t -> true);
        return this.delegate == null || this.delegate.onChunkStart(context, chunkIndex, header);
    }

    @Override
    public final boolean onChunkEnd(ParserContext context, int chunkIndex, boolean skipped) {
        context.remove(TypeFilter.class);
        return this.delegate == null || this.delegate.onChunkEnd(context, chunkIndex, skipped);
    }

    @Override
    public final boolean onEvent(ParserContext context, long typeId, long eventStartPos, long rawSize, long payloadSize) {
        ControlImpl ctl = (ControlImpl)this.control.get();
        try {
            MetadataClass eventClz = context.getMetadataLookup().getClass(typeId);
            RecordingStream stream = context.get(RecordingStream.class);
            UntypedDeserializerCache cache = context.get(UntypedDeserializerCache.class);
            if (cache == null) {
                return !ctl.abortFlag && this.delegate != null && this.delegate.onEvent(context, typeId, eventStartPos, rawSize, payloadSize);
            }
            UntypedStrategy strategy = context.get(UntypedStrategy.class);
            if (strategy == null) {
                strategy = UntypedStrategy.SPARSE_ACCESS;
            }
            UntypedStrategy finalStrategy = strategy;
            UntypedEventDeserializer deserializer = cache.computeIfAbsent(typeId, id -> {
                try {
                    return UntypedCodeGenerator.generate(eventClz, finalStrategy);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to generate deserializer for event type: " + eventClz.getName(), e);
                }
            });
            Map<String, Object> value = deserializer.deserialize(stream, context);
            this.onEventValue(eventClz, value, ctl);
        }
        catch (Exception e) {
            return !ctl.abortFlag && this.delegate != null && this.delegate.onEvent(context, typeId, eventStartPos, rawSize, payloadSize);
        }
        return !ctl.abortFlag && (this.delegate == null || this.delegate.onEvent(context, typeId, eventStartPos, rawSize, payloadSize));
    }

    @Override
    public final void onRecordingStart(ParserContext context) {
        if (this.delegate != null) {
            this.delegate.onRecordingStart(context);
        } else {
            ChunkParserListener.super.onRecordingStart(context);
        }
    }

    @Override
    public final boolean onCheckpoint(ParserContext context, CheckpointEvent checkpoint) {
        return this.delegate != null ? this.delegate.onCheckpoint(context, checkpoint) : ChunkParserListener.super.onCheckpoint(context, checkpoint);
    }

    @Override
    public final void onRecordingEnd(ParserContext context) {
        if (this.delegate != null) {
            this.delegate.onRecordingEnd(context);
        } else {
            ChunkParserListener.super.onRecordingEnd(context);
        }
    }

    protected abstract void onEventValue(MetadataClass var1, Map<String, Object> var2, Control var3);
}

