/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ComplexType;
import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.MapValueBuilder;
import io.jafar.parser.internal_api.GenericValueReader;
import io.jafar.parser.internal_api.MutableConstantPool;
import io.jafar.parser.internal_api.MutableConstantPools;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.util.Map;
import java.util.Objects;

final class ConstantPoolAccessor
implements ComplexType {
    private final ParserContext context;
    private final long typeId;
    private final long pointer;
    private volatile Map<String, Object> cached;

    ConstantPoolAccessor(ParserContext context, MetadataClass type, long pointer) {
        this.context = context;
        this.typeId = type.getId();
        this.pointer = pointer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getValue() {
        Map<String, Object> v = this.cached;
        if (v != null) {
            return v;
        }
        ConstantPoolAccessor constantPoolAccessor = this;
        synchronized (constantPoolAccessor) {
            v = this.cached;
            if (v != null) {
                return v;
            }
            MutableConstantPools pools = (MutableConstantPools)this.context.getConstantPools();
            MutableConstantPool pool = pools.getConstantPool(this.typeId);
            if (pool == null) {
                return null;
            }
            long offset = pool.getOffset(this.pointer);
            if (offset == 0L) {
                return null;
            }
            RecordingStream stream = this.context.get(RecordingStream.class);
            long pos = stream.position();
            try {
                stream.position(offset);
                MetadataClass clz = this.context.getMetadataLookup().getClass(this.typeId);
                if (clz.isSimpleType() && clz.getFields().size() == 1) {
                    MetadataField singleField = clz.getFields().get(0);
                    MetadataClass fieldType = singleField.getType();
                    while (fieldType.isSimpleType() && fieldType.getFields().size() == 1) {
                        fieldType = fieldType.getFields().get(0).getType();
                    }
                    MapValueBuilder builder = new MapValueBuilder(this.context);
                    GenericValueReader r = new GenericValueReader(builder);
                    builder.onComplexValueStart(null, null, clz);
                    r.readSingleValue(stream, fieldType, singleField.getName());
                    builder.onComplexValueEnd(null, null, clz);
                    this.cached = v = builder.getRoot();
                    Map<String, Object> map = v;
                    return map;
                }
                MapValueBuilder builder = new MapValueBuilder(this.context);
                GenericValueReader r = new GenericValueReader(builder);
                builder.onComplexValueStart(null, null, clz);
                r.readValue(stream, clz);
                builder.onComplexValueEnd(null, null, clz);
                this.cached = v = builder.getRoot();
                Map<String, Object> map = v;
                return map;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                stream.position(pos);
            }
        }
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }
}

