/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.api;

import io.jafar.parser.api.JafarConfigurationException;
import io.jafar.parser.api.JafarIOException;
import io.jafar.parser.api.JafarParseException;
import io.jafar.parser.api.JafarSerializationException;

public interface ErrorHandler {
    public static final ErrorHandler DEFAULT = new ErrorHandler(){

        @Override
        public void handleConfigurationError(JafarConfigurationException e) {
            throw new RuntimeException("Configuration error: " + e.getMessage(), e);
        }

        @Override
        public void handleSerializationError(JafarSerializationException e) {
            throw new RuntimeException("Serialization error: " + e.getMessage(), e);
        }

        @Override
        public void handleIOError(JafarIOException e) {
            throw new RuntimeException("I/O error: " + e.getMessage(), e);
        }

        @Override
        public void handleGenericError(JafarParseException e) {
            throw new RuntimeException("Parse error: " + e.getMessage(), e);
        }
    };

    public void handleConfigurationError(JafarConfigurationException var1);

    public void handleSerializationError(JafarSerializationException var1);

    public void handleIOError(JafarIOException var1);

    public void handleGenericError(JafarParseException var1);

    public static ErrorHandler lenient() {
        return new ErrorHandler(){

            @Override
            public void handleConfigurationError(JafarConfigurationException e) {
                System.err.println("Warning - Configuration error: " + e.getMessage());
            }

            @Override
            public void handleSerializationError(JafarSerializationException e) {
                System.err.println("Warning - Serialization error: " + e.getMessage());
            }

            @Override
            public void handleIOError(JafarIOException e) {
                System.err.println("Warning - I/O error: " + e.getMessage());
            }

            @Override
            public void handleGenericError(JafarParseException e) {
                System.err.println("Warning - Parse error: " + e.getMessage());
            }
        };
    }
}

