/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.Objects;

final class MetadataSetting
extends AbstractMetadataElement {
    private boolean hasHashCode = false;
    private int hashCode;
    private String value;
    private long typeId;

    public MetadataSetting(RecordingStream stream, MetadataEvent event) throws IOException {
        super(stream, MetadataElementKind.SETTING);
        this.readSubelements(event);
    }

    @Override
    protected void onAttribute(String key, String value) {
        switch (key) {
            case "defaultValue": {
                this.value = value;
                break;
            }
            case "class": {
                this.typeId = ParsingUtils.parseLongSWAR(value);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public MetadataClass getType() {
        return this.metadataLookup.getClass(this.typeId);
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitSetting(this);
        visitor.visitEnd(this);
    }

    public String toString() {
        return "MetadataSetting{type='" + (this.getType() != null ? this.getType().getName() : Long.valueOf(this.typeId)) + "', name='" + this.getName() + "', value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSetting that = (MetadataSetting)o;
        return this.typeId == that.typeId && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            long mixed = this.typeId * -7046029254386353131L + (long)Objects.hashCode(this.value) * -4126379630918253789L;
            this.hashCode = Long.hashCode(mixed);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

