/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataRegion;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.Objects;

public final class MetadataRoot
extends AbstractMetadataElement {
    private boolean hasHashHascode = false;
    private int hashCode;
    private MetadataElement metadata;
    private MetadataRegion region;

    MetadataRoot(RecordingStream stream, MetadataEvent event) throws IOException {
        super(stream, MetadataElementKind.ROOT);
        this.readSubelements(event);
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        if (element.getKind() == MetadataElementKind.META) {
            this.metadata = (MetadataElement)element;
        } else if (element.getKind() == MetadataElementKind.REGION) {
            this.region = (MetadataRegion)element;
        } else {
            throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitRoot(this);
        this.metadata.accept(visitor);
        this.region.accept(visitor);
        visitor.visitEnd(this);
    }

    public String toString() {
        return "MetadataRoot";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataRoot that = (MetadataRoot)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.region, that.region);
    }

    public int hashCode() {
        if (!this.hasHashHascode) {
            this.hashCode = Objects.hash(this.metadata, this.region);
            this.hasHashHascode = true;
        }
        return this.hashCode;
    }
}

