/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.ParsingUtils;
import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataAnnotation;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MetadataField
extends AbstractMetadataElement {
    private boolean hasHashCode = false;
    private int hashCode;
    private List<MetadataAnnotation> annotations = null;
    private Long classId;
    private String classIdVal;
    private Boolean hasConstantPool;
    private String hasConstantPoolVal;
    private Integer dimension;
    private String dimensionVal;
    private MetadataClass type = null;

    MetadataField(RecordingStream stream, MetadataEvent event, boolean forceConstantPools) throws IOException {
        super(stream, MetadataElementKind.FIELD);
        this.readSubelements(event);
    }

    @Override
    protected void onAttribute(String key, String value) {
        switch (key) {
            case "class": {
                this.classIdVal = value;
                break;
            }
            case "constantPool": {
                this.hasConstantPoolVal = value;
                break;
            }
            case "dimension": {
                this.dimensionVal = value;
            }
        }
    }

    public MetadataClass getType() {
        if (this.type == null) {
            this.type = this.metadataLookup.getClass(this.getTypeId());
        }
        return this.type;
    }

    public long getTypeId() {
        if (this.classId == null) {
            this.classId = ParsingUtils.parseLongSWAR(this.classIdVal);
        }
        return this.classId;
    }

    public boolean hasConstantPool() {
        if (this.hasConstantPool == null) {
            this.hasConstantPool = Boolean.parseBoolean(this.hasConstantPoolVal);
        }
        return this.hasConstantPool;
    }

    public int getDimension() {
        if (this.dimension == null) {
            this.dimension = this.dimensionVal != null ? Integer.parseInt(this.dimensionVal) : -1;
        }
        return this.dimension;
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        if (element.getKind() == MetadataElementKind.ANNOTATION) {
            if (this.annotations == null) {
                this.annotations = new ArrayList<MetadataAnnotation>(count);
            }
        } else {
            throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
        }
        this.annotations.add((MetadataAnnotation)element);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitField(this);
        if (this.annotations != null) {
            this.annotations.forEach(a -> a.accept(visitor));
        }
        visitor.visitEnd(this);
    }

    public List<MetadataAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations == null ? Collections.emptyList() : this.annotations);
    }

    public String toString() {
        return "MetadataField{type='" + (this.getType() != null ? this.getType().getName() : Long.valueOf(this.getTypeId())) + '\'' + ", name='" + this.getName() + "', hasConstantPool=" + this.hasConstantPool + ", dimension=" + this.dimension + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataField that = (MetadataField)o;
        return this.getTypeId() == that.getTypeId() && this.hasConstantPool() == that.hasConstantPool() && this.getDimension() == that.getDimension();
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            long mixed = this.getTypeId() * -7046029254386353131L + (long)(this.hasConstantPool() ? 1 : 0) * -4126379630918253789L + (long)this.getDimension() * -2876049455945701127L;
            this.hashCode = Long.hashCode(mixed);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

