/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.collections;

import java.util.Arrays;

public final class LongLongHashMap {
    private static final long EMPTY_KEY = Long.MIN_VALUE;
    private static final long PHI_MIX = -7046029254386353131L;
    private long[] keys;
    private long[] values;
    private int mask;
    private int size;
    private int threshold;

    public LongLongHashMap(int expectedSize) {
        int capacity = LongLongHashMap.tableSizeFor(expectedSize);
        this.keys = new long[capacity];
        this.values = new long[capacity];
        this.mask = capacity - 1;
        this.threshold = capacity * 3 >>> 2;
        LongLongHashMap.fillEmpty(this.keys);
    }

    public long get(long key) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                return 0L;
            }
            idx = idx + 1 & this.mask;
        }
        return this.values[idx];
    }

    public void put(long key, long value) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        while (true) {
            long k;
            if ((k = this.keys[idx]) == Long.MIN_VALUE) {
                this.keys[idx] = key;
                this.values[idx] = value;
                if (++this.size >= this.threshold) {
                    this.rehash();
                }
                return;
            }
            if (k == key) {
                this.values[idx] = value;
                return;
            }
            idx = idx + 1 & this.mask;
        }
    }

    public boolean containsKey(long key) {
        assert (key != Long.MIN_VALUE) : "Long.MIN_VALUE is reserved as sentinel key";
        int idx = this.index(key);
        long k;
        while ((k = this.keys[idx]) != key) {
            if (k == Long.MIN_VALUE) {
                return false;
            }
            idx = idx + 1 & this.mask;
        }
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public LongIterator keyIterator() {
        return new LongIterator(){
            private int idx = 0;
            private int remaining = LongLongHashMap.access$000(LongLongHashMap.this);

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            @Override
            public long nextLong() {
                while (LongLongHashMap.this.keys[this.idx] == Long.MIN_VALUE) {
                    ++this.idx;
                }
                --this.remaining;
                return LongLongHashMap.this.keys[this.idx++];
            }
        };
    }

    private int index(long key) {
        return (int)(key * -7046029254386353131L >>> 64 - Integer.numberOfTrailingZeros(this.keys.length)) & this.mask;
    }

    private void rehash() {
        long[] oldKeys = this.keys;
        long[] oldValues = this.values;
        int newCapacity = oldKeys.length << 1;
        this.keys = new long[newCapacity];
        this.values = new long[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = newCapacity * 3 >>> 2;
        LongLongHashMap.fillEmpty(this.keys);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == Long.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private static void fillEmpty(long[] a) {
        Arrays.fill(a, Long.MIN_VALUE);
    }

    private static int tableSizeFor(int expected) {
        int n = Math.max(4, expected + (expected >>> 1));
        n = Integer.highestOneBit(n - 1) << 1;
        return n;
    }

    static /* synthetic */ int access$000(LongLongHashMap x0) {
        return x0.size;
    }

    public static interface LongIterator {
        public boolean hasNext();

        public long nextLong();
    }
}

