/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.utils;

import io.jafar.utils.SplicedMappedByteBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface CustomByteBuffer {
    public static CustomByteBuffer map(Path channel) throws IOException {
        return CustomByteBuffer.map(channel, Integer.MAX_VALUE);
    }

    public static CustomByteBuffer map(Path path, int spliceSize) throws IOException {
        long size = Files.size(path);
        if (size > (long)spliceSize) {
            return new SplicedMappedByteBuffer(path, spliceSize);
        }
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
            ByteBufferWrapper byteBufferWrapper;
            block12: {
                FileChannel channel = raf.getChannel();
                try {
                    byteBufferWrapper = new ByteBufferWrapper(channel.map(FileChannel.MapMode.READ_ONLY, 0L, size));
                    if (channel == null) break block12;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return byteBufferWrapper;
        }
    }

    public CustomByteBuffer slice();

    public CustomByteBuffer slice(long var1, long var3);

    public CustomByteBuffer order(ByteOrder var1);

    public ByteOrder order();

    public boolean isNativeOrder();

    public void position(long var1);

    public long position();

    public long remaining();

    public void get(byte[] var1, int var2, int var3);

    public byte get();

    public short getShort();

    public int getInt();

    public float getFloat();

    public double getDouble();

    public void mark();

    public void reset();

    public long getLong();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ByteBufferWrapper
    implements CustomByteBuffer {
        private final MappedByteBuffer delegate;
        private final boolean nativeOrder;

        public ByteBufferWrapper(MappedByteBuffer delegate) {
            this.delegate = delegate;
            this.nativeOrder = delegate.order() == ByteOrder.nativeOrder();
            delegate.order(ByteOrder.nativeOrder());
        }

        @Override
        public boolean isNativeOrder() {
            return this.nativeOrder;
        }

        @Override
        public CustomByteBuffer slice(long pos, long len) {
            return new ByteBufferWrapper(this.delegate.slice((int)pos, (int)len));
        }

        @Override
        public CustomByteBuffer slice() {
            return new ByteBufferWrapper(this.delegate.slice());
        }

        @Override
        public CustomByteBuffer order(ByteOrder order) {
            this.delegate.order(order);
            return this;
        }

        @Override
        public ByteOrder order() {
            return this.delegate.order();
        }

        @Override
        public void position(long position) {
            this.delegate.position((int)position);
        }

        @Override
        public long position() {
            return this.delegate.position();
        }

        @Override
        public long remaining() {
            return this.delegate.remaining();
        }

        @Override
        public void get(byte[] buffer, int offset, int length) {
            this.delegate.get(buffer, offset, length);
        }

        @Override
        public byte get() {
            return this.delegate.get();
        }

        @Override
        public short getShort() {
            return this.delegate.getShort();
        }

        @Override
        public int getInt() {
            return this.delegate.getInt();
        }

        @Override
        public float getFloat() {
            return this.delegate.getFloat();
        }

        @Override
        public double getDouble() {
            return this.delegate.getDouble();
        }

        @Override
        public void mark() {
            this.delegate.mark();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public long getLong() {
            return this.delegate.getLong();
        }
    }
}

