/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.importer;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class Import {
    private final URI importUri;
    private final URI absoluteUri;
    private final String contents;
    private final String sourceMap;

    public Import(URI importUri, URI absoluteUri) {
        this(importUri, absoluteUri, null, null);
    }

    public Import(URI importUri, URI absoluteUri, String contents) {
        this(importUri, absoluteUri, contents, null);
    }

    public Import(URI importUri, URI absoluteUri, String contents, String sourceMap) {
        this.importUri = importUri;
        this.absoluteUri = absoluteUri;
        this.contents = contents;
        this.sourceMap = sourceMap;
    }

    public Import(String importUri, String absoluteUri) throws URISyntaxException {
        this(importUri, absoluteUri, null, null);
    }

    public Import(String importUri, String absoluteUri, String contents) throws URISyntaxException {
        this(importUri, absoluteUri, contents, null);
    }

    public Import(String importUri, String absoluteUri, String contents, String sourceMap) throws URISyntaxException {
        URI tempAbsoluteUri;
        URI tempImportUri;
        try {
            tempImportUri = new URI(importUri);
        }
        catch (URISyntaxException e) {
            tempImportUri = new File(importUri).toURI();
        }
        this.importUri = tempImportUri;
        try {
            tempAbsoluteUri = new URI(absoluteUri);
        }
        catch (URISyntaxException e) {
            tempAbsoluteUri = new File(absoluteUri).toURI();
        }
        this.absoluteUri = tempAbsoluteUri;
        this.contents = contents;
        this.sourceMap = sourceMap;
    }

    public URI getImportUri() {
        return this.importUri;
    }

    public URI getAbsoluteUri() {
        return this.absoluteUri;
    }

    public String getContents() {
        return this.contents;
    }

    public String getSourceMap() {
        return this.sourceMap;
    }
}

