/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import io.bit3.jsass.annotation.DefaultBooleanValue;
import io.bit3.jsass.annotation.DefaultByteValue;
import io.bit3.jsass.annotation.DefaultCharacterValue;
import io.bit3.jsass.annotation.DefaultDoubleValue;
import io.bit3.jsass.annotation.DefaultFloatValue;
import io.bit3.jsass.annotation.DefaultIntegerValue;
import io.bit3.jsass.annotation.DefaultLongValue;
import io.bit3.jsass.annotation.DefaultShortValue;
import io.bit3.jsass.annotation.DefaultStringValue;
import io.bit3.jsass.annotation.Name;
import io.bit3.jsass.function.FunctionArgumentSignature;
import io.bit3.jsass.type.TypeUtils;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.List;

public class FunctionArgumentSignatureFactory {
    public List<FunctionArgumentSignature> createDefaultArgumentSignature(Parameter parameter) {
        LinkedList<FunctionArgumentSignature> list = new LinkedList<FunctionArgumentSignature>();
        String name = this.getParameterName(parameter);
        Object defaultValue = this.getDefaultValue(parameter);
        list.add(new FunctionArgumentSignature(name, defaultValue));
        return list;
    }

    public String getParameterName(Parameter parameter) {
        Name annotation = parameter.getAnnotation(Name.class);
        if (null == annotation) {
            return parameter.getName();
        }
        return annotation.value();
    }

    public Object getDefaultValue(Parameter parameter) {
        Class<?> type = parameter.getType();
        if (TypeUtils.isaString(type)) {
            return FunctionArgumentSignatureFactory.getStringDefaultValue(parameter);
        }
        if (TypeUtils.isaByte(type)) {
            return FunctionArgumentSignatureFactory.getByteDefaultValue(parameter);
        }
        if (TypeUtils.isaShort(type)) {
            return FunctionArgumentSignatureFactory.getShortDefaultValue(parameter);
        }
        if (TypeUtils.isaInteger(type)) {
            return FunctionArgumentSignatureFactory.getIntegerDefaultValue(parameter);
        }
        if (TypeUtils.isaLong(type)) {
            return FunctionArgumentSignatureFactory.getLongDefaultValue(parameter);
        }
        if (TypeUtils.isaFloat(type)) {
            return FunctionArgumentSignatureFactory.getFloatDefaultValue(parameter);
        }
        if (TypeUtils.isaDouble(type)) {
            return FunctionArgumentSignatureFactory.getDoubleDefaultValue(parameter);
        }
        if (TypeUtils.isaCharacter(type)) {
            return FunctionArgumentSignatureFactory.getCharacterDefaultValue(parameter);
        }
        if (TypeUtils.isaBoolean(type)) {
            return FunctionArgumentSignatureFactory.getBooleanDefaultValue(parameter);
        }
        return null;
    }

    private static Object getStringDefaultValue(Parameter parameter) {
        DefaultStringValue defaultStringValue = parameter.getAnnotation(DefaultStringValue.class);
        if (null != defaultStringValue) {
            return defaultStringValue.value();
        }
        return null;
    }

    private static Object getByteDefaultValue(Parameter parameter) {
        DefaultByteValue defaultByteValue = parameter.getAnnotation(DefaultByteValue.class);
        if (null != defaultByteValue) {
            return defaultByteValue.value();
        }
        return null;
    }

    private static Object getShortDefaultValue(Parameter parameter) {
        DefaultShortValue defaultShortValue = parameter.getAnnotation(DefaultShortValue.class);
        if (null != defaultShortValue) {
            return defaultShortValue.value();
        }
        return null;
    }

    private static Object getIntegerDefaultValue(Parameter parameter) {
        DefaultIntegerValue defaultIntegerValue = parameter.getAnnotation(DefaultIntegerValue.class);
        if (null != defaultIntegerValue) {
            return defaultIntegerValue.value();
        }
        return null;
    }

    private static Object getLongDefaultValue(Parameter parameter) {
        DefaultLongValue defaultLongValue = parameter.getAnnotation(DefaultLongValue.class);
        if (null != defaultLongValue) {
            return defaultLongValue.value();
        }
        return null;
    }

    private static Object getFloatDefaultValue(Parameter parameter) {
        DefaultFloatValue defaultFloatValue = parameter.getAnnotation(DefaultFloatValue.class);
        if (null != defaultFloatValue) {
            return Float.valueOf(defaultFloatValue.value());
        }
        return null;
    }

    private static Object getDoubleDefaultValue(Parameter parameter) {
        DefaultDoubleValue defaultDoubleValue = parameter.getAnnotation(DefaultDoubleValue.class);
        if (null != defaultDoubleValue) {
            return defaultDoubleValue.value();
        }
        return null;
    }

    private static Object getCharacterDefaultValue(Parameter parameter) {
        DefaultCharacterValue defaultCharacterValue = parameter.getAnnotation(DefaultCharacterValue.class);
        if (null != defaultCharacterValue) {
            return Character.valueOf(defaultCharacterValue.value());
        }
        return null;
    }

    private static Object getBooleanDefaultValue(Parameter parameter) {
        DefaultBooleanValue defaultBooleanValue = parameter.getAnnotation(DefaultBooleanValue.class);
        if (null != defaultBooleanValue) {
            return defaultBooleanValue.value();
        }
        return null;
    }
}

